/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.impl.dom4j.bean;

import gg.essential.elementa.impl.dom4j.Attribute;
import gg.essential.elementa.impl.dom4j.QName;
import gg.essential.elementa.impl.dom4j.bean.BeanAttribute;
import gg.essential.elementa.impl.dom4j.bean.BeanElement;
import gg.essential.elementa.impl.dom4j.bean.BeanMetaData;
import java.util.AbstractList;

public class BeanAttributeList
extends AbstractList<Attribute> {
    private BeanElement parent;
    private BeanMetaData beanMetaData;
    private BeanAttribute[] attributes;

    public BeanAttributeList(BeanElement parent, BeanMetaData beanMetaData) {
        this.parent = parent;
        this.beanMetaData = beanMetaData;
        this.attributes = new BeanAttribute[beanMetaData.attributeCount()];
    }

    public BeanAttributeList(BeanElement parent) {
        this.parent = parent;
        Object data2 = parent.getData();
        Class<?> beanClass = data2 != null ? data2.getClass() : null;
        this.beanMetaData = BeanMetaData.get(beanClass);
        this.attributes = new BeanAttribute[this.beanMetaData.attributeCount()];
    }

    public BeanAttribute attribute(String name) {
        int index2 = this.beanMetaData.getIndex(name);
        return this.attribute(index2);
    }

    public BeanAttribute attribute(QName qname) {
        int index2 = this.beanMetaData.getIndex(qname);
        return this.attribute(index2);
    }

    public BeanAttribute attribute(int index2) {
        if (index2 >= 0 && index2 <= this.attributes.length) {
            BeanAttribute attribute = this.attributes[index2];
            if (attribute == null) {
                this.attributes[index2] = attribute = this.createAttribute(this.parent, index2);
            }
            return attribute;
        }
        return null;
    }

    public BeanElement getParent() {
        return this.parent;
    }

    public QName getQName(int index2) {
        return this.beanMetaData.getQName(index2);
    }

    public Object getData(int index2) {
        return this.beanMetaData.getData(index2, this.parent.getData());
    }

    public void setData(int index2, Object data2) {
        this.beanMetaData.setData(index2, this.parent.getData(), data2);
    }

    @Override
    public int size() {
        return this.attributes.length;
    }

    @Override
    public BeanAttribute get(int index2) {
        BeanAttribute attribute = this.attributes[index2];
        if (attribute == null) {
            this.attributes[index2] = attribute = this.createAttribute(this.parent, index2);
        }
        return attribute;
    }

    @Override
    public boolean add(BeanAttribute object) {
        throw new UnsupportedOperationException("add(Object) unsupported");
    }

    @Override
    public void add(int index2, BeanAttribute object) {
        throw new UnsupportedOperationException("add(int,Object) unsupported");
    }

    @Override
    public BeanAttribute set(int index2, BeanAttribute object) {
        throw new UnsupportedOperationException("set(int,Object) unsupported");
    }

    @Override
    public boolean remove(Object object) {
        return false;
    }

    @Override
    public BeanAttribute remove(int index2) {
        BeanAttribute attribute = this.get(index2);
        attribute.setValue(null);
        return attribute;
    }

    @Override
    public void clear() {
        for (BeanAttribute attribute : this.attributes) {
            if (attribute == null) continue;
            attribute.setValue(null);
        }
    }

    protected BeanAttribute createAttribute(BeanElement element, int index2) {
        return new BeanAttribute(this, index2);
    }
}

