/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.impl.commonmark.internal.util;

import gg.essential.elementa.impl.commonmark.internal.util.CharMatcher;
import java.util.BitSet;

public class AsciiMatcher
implements CharMatcher {
    private final BitSet set;

    private AsciiMatcher(Builder builder) {
        this.set = builder.set;
    }

    @Override
    public boolean matches(char c) {
        return this.set.get(c);
    }

    public Builder newBuilder() {
        return new Builder((BitSet)this.set.clone());
    }

    public static Builder builder() {
        return new Builder(new BitSet());
    }

    public static class Builder {
        private final BitSet set;

        private Builder(BitSet set) {
            this.set = set;
        }

        public Builder c(char c) {
            if (c > '\u007f') {
                throw new IllegalArgumentException("Can only match ASCII characters");
            }
            this.set.set(c);
            return this;
        }

        public Builder range(char from2, char toInclusive) {
            for (char c = from2; c <= toInclusive; c = (char)(c + '\u0001')) {
                this.c(c);
            }
            return this;
        }

        public AsciiMatcher build() {
            return new AsciiMatcher(this);
        }
    }
}

