/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.impl.commonmark.internal.inline;

import gg.essential.elementa.impl.commonmark.internal.inline.Position;
import gg.essential.elementa.impl.commonmark.internal.util.CharMatcher;
import gg.essential.elementa.impl.commonmark.node.SourceSpan;
import gg.essential.elementa.impl.commonmark.parser.SourceLine;
import gg.essential.elementa.impl.commonmark.parser.SourceLines;
import java.util.List;

public class Scanner {
    public static final char END = '\u0000';
    private final List<SourceLine> lines;
    private int lineIndex;
    private int index;
    private SourceLine line = SourceLine.of("", null);
    private int lineLength = 0;

    Scanner(List<SourceLine> lines, int lineIndex, int index2) {
        this.lines = lines;
        this.lineIndex = lineIndex;
        this.index = index2;
        if (!lines.isEmpty()) {
            this.checkPosition(lineIndex, index2);
            this.setLine(lines.get(lineIndex));
        }
    }

    public static Scanner of(SourceLines lines) {
        return new Scanner(lines.getLines(), 0, 0);
    }

    public char peek() {
        if (this.index < this.lineLength) {
            return this.line.getContent().charAt(this.index);
        }
        if (this.lineIndex < this.lines.size() - 1) {
            return '\n';
        }
        return '\u0000';
    }

    public int peekCodePoint() {
        if (this.index < this.lineLength) {
            char low;
            char c = this.line.getContent().charAt(this.index);
            if (Character.isHighSurrogate(c) && this.index + 1 < this.lineLength && Character.isLowSurrogate(low = this.line.getContent().charAt(this.index + 1))) {
                return Character.toCodePoint(c, low);
            }
            return c;
        }
        if (this.lineIndex < this.lines.size() - 1) {
            return 10;
        }
        return 0;
    }

    public int peekPreviousCodePoint() {
        if (this.index > 0) {
            char high;
            int prev = this.index - 1;
            char c = this.line.getContent().charAt(prev);
            if (Character.isLowSurrogate(c) && prev > 0 && Character.isHighSurrogate(high = this.line.getContent().charAt(prev - 1))) {
                return Character.toCodePoint(high, c);
            }
            return c;
        }
        if (this.lineIndex > 0) {
            return 10;
        }
        return 0;
    }

    public boolean hasNext() {
        if (this.index < this.lineLength) {
            return true;
        }
        return this.lineIndex < this.lines.size() - 1;
    }

    public void next() {
        ++this.index;
        if (this.index > this.lineLength) {
            ++this.lineIndex;
            if (this.lineIndex < this.lines.size()) {
                this.setLine(this.lines.get(this.lineIndex));
            } else {
                this.setLine(SourceLine.of("", null));
            }
            this.index = 0;
        }
    }

    public boolean next(char c) {
        if (this.peek() == c) {
            this.next();
            return true;
        }
        return false;
    }

    public boolean next(String content) {
        if (this.index < this.lineLength && this.index + content.length() <= this.lineLength) {
            for (int i = 0; i < content.length(); ++i) {
                if (this.line.getContent().charAt(this.index + i) == content.charAt(i)) continue;
                return false;
            }
            this.index += content.length();
            return true;
        }
        return false;
    }

    public int matchMultiple(char c) {
        int count2 = 0;
        while (this.peek() == c) {
            ++count2;
            this.next();
        }
        return count2;
    }

    public int match(CharMatcher matcher) {
        int count2 = 0;
        while (matcher.matches(this.peek())) {
            ++count2;
            this.next();
        }
        return count2;
    }

    public int whitespace() {
        int count2 = 0;
        block3: while (true) {
            switch (this.peek()) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    ++count2;
                    this.next();
                    continue block3;
                }
            }
            break;
        }
        return count2;
    }

    public int find(char c) {
        int count2 = 0;
        char cur;
        while ((cur = this.peek()) != '\u0000') {
            if (cur == c) {
                return count2;
            }
            ++count2;
            this.next();
        }
        return -1;
    }

    public int find(CharMatcher matcher) {
        int count2 = 0;
        char c;
        while ((c = this.peek()) != '\u0000') {
            if (matcher.matches(c)) {
                return count2;
            }
            ++count2;
            this.next();
        }
        return -1;
    }

    public Position position() {
        return new Position(this.lineIndex, this.index);
    }

    public void setPosition(Position position) {
        this.checkPosition(position.lineIndex, position.index);
        this.lineIndex = position.lineIndex;
        this.index = position.index;
        this.setLine(this.lines.get(this.lineIndex));
    }

    public SourceLines getSource(Position begin, Position end) {
        if (begin.lineIndex == end.lineIndex) {
            SourceLine line2 = this.lines.get(begin.lineIndex);
            CharSequence newContent = line2.getContent().subSequence(begin.index, end.index);
            SourceSpan newSourceSpan = null;
            SourceSpan sourceSpan = line2.getSourceSpan();
            if (sourceSpan != null) {
                newSourceSpan = SourceSpan.of(sourceSpan.getLineIndex(), sourceSpan.getColumnIndex() + begin.index, newContent.length());
            }
            return SourceLines.of(SourceLine.of(newContent, newSourceSpan));
        }
        SourceLines sourceLines = SourceLines.empty();
        SourceLine firstLine = this.lines.get(begin.lineIndex);
        sourceLines.addLine(firstLine.substring(begin.index, firstLine.getContent().length()));
        for (int line3 = begin.lineIndex + 1; line3 < end.lineIndex; ++line3) {
            sourceLines.addLine(this.lines.get(line3));
        }
        SourceLine lastLine = this.lines.get(end.lineIndex);
        sourceLines.addLine(lastLine.substring(0, end.index));
        return sourceLines;
    }

    private void setLine(SourceLine line2) {
        this.line = line2;
        this.lineLength = line2.getContent().length();
    }

    private void checkPosition(int lineIndex, int index2) {
        if (lineIndex < 0 || lineIndex >= this.lines.size()) {
            throw new IllegalArgumentException("Line index " + lineIndex + " out of range, number of lines: " + this.lines.size());
        }
        SourceLine line2 = this.lines.get(lineIndex);
        if (index2 < 0 || index2 > line2.getContent().length()) {
            throw new IllegalArgumentException("Index " + index2 + " out of range, line length: " + line2.getContent().length());
        }
    }
}

