/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.impl.commonmark.internal.inline;

import gg.essential.elementa.impl.commonmark.internal.inline.InlineContentParser;
import gg.essential.elementa.impl.commonmark.internal.inline.InlineParserState;
import gg.essential.elementa.impl.commonmark.internal.inline.ParsedInline;
import gg.essential.elementa.impl.commonmark.internal.inline.Scanner;
import gg.essential.elementa.impl.commonmark.node.HardLineBreak;
import gg.essential.elementa.impl.commonmark.node.Text;
import java.util.regex.Pattern;

public class BackslashInlineParser
implements InlineContentParser {
    private static final Pattern ESCAPABLE = Pattern.compile("^[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]");

    @Override
    public ParsedInline tryParse(InlineParserState inlineParserState) {
        Scanner scanner = inlineParserState.scanner();
        scanner.next();
        char next = scanner.peek();
        if (next == '\n') {
            scanner.next();
            return ParsedInline.of(new HardLineBreak(), scanner.position());
        }
        if (ESCAPABLE.matcher(String.valueOf(next)).matches()) {
            scanner.next();
            return ParsedInline.of(new Text(String.valueOf(next)), scanner.position());
        }
        return ParsedInline.of(new Text("\\"), scanner.position());
    }
}

