/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.impl.commonmark.internal;

import gg.essential.elementa.impl.commonmark.internal.util.Escaping;
import gg.essential.elementa.impl.commonmark.internal.util.Parsing;
import gg.essential.elementa.impl.commonmark.node.Block;
import gg.essential.elementa.impl.commonmark.node.FencedCodeBlock;
import gg.essential.elementa.impl.commonmark.parser.SourceLine;
import gg.essential.elementa.impl.commonmark.parser.block.AbstractBlockParser;
import gg.essential.elementa.impl.commonmark.parser.block.AbstractBlockParserFactory;
import gg.essential.elementa.impl.commonmark.parser.block.BlockContinue;
import gg.essential.elementa.impl.commonmark.parser.block.BlockStart;
import gg.essential.elementa.impl.commonmark.parser.block.MatchedBlockParser;
import gg.essential.elementa.impl.commonmark.parser.block.ParserState;

public class FencedCodeBlockParser
extends AbstractBlockParser {
    private final FencedCodeBlock block = new FencedCodeBlock();
    private String firstLine;
    private StringBuilder otherLines = new StringBuilder();

    public FencedCodeBlockParser(char fenceChar, int fenceLength, int fenceIndent) {
        this.block.setFenceChar(fenceChar);
        this.block.setFenceLength(fenceLength);
        this.block.setFenceIndent(fenceIndent);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        int nextNonSpace = state.getNextNonSpaceIndex();
        int newIndex = state.getIndex();
        CharSequence line2 = state.getLine().getContent();
        if (state.getIndent() < Parsing.CODE_BLOCK_INDENT && nextNonSpace < line2.length() && line2.charAt(nextNonSpace) == this.block.getFenceChar() && this.isClosing(line2, nextNonSpace)) {
            return BlockContinue.finished();
        }
        int length = line2.length();
        for (int i = this.block.getFenceIndent(); i > 0 && newIndex < length && line2.charAt(newIndex) == ' '; ++newIndex, --i) {
        }
        return BlockContinue.atIndex(newIndex);
    }

    @Override
    public void addLine(SourceLine line2) {
        if (this.firstLine == null) {
            this.firstLine = line2.getContent().toString();
        } else {
            this.otherLines.append(line2.getContent());
            this.otherLines.append('\n');
        }
    }

    @Override
    public void closeBlock() {
        this.block.setInfo(Escaping.unescapeString(this.firstLine.trim()));
        this.block.setLiteral(this.otherLines.toString());
    }

    private static FencedCodeBlockParser checkOpener(CharSequence line2, int index2, int indent) {
        int backticks = 0;
        int tildes = 0;
        int length = line2.length();
        block4: for (int i = index2; i < length; ++i) {
            switch (line2.charAt(i)) {
                case '`': {
                    ++backticks;
                    continue block4;
                }
                case '~': {
                    ++tildes;
                    continue block4;
                }
            }
        }
        if (backticks >= 3 && tildes == 0) {
            if (Parsing.find('`', line2, index2 + backticks) != -1) {
                return null;
            }
            return new FencedCodeBlockParser('`', backticks, indent);
        }
        if (tildes >= 3 && backticks == 0) {
            return new FencedCodeBlockParser('~', tildes, indent);
        }
        return null;
    }

    private boolean isClosing(CharSequence line2, int index2) {
        char fenceChar = this.block.getFenceChar();
        int fenceLength = this.block.getFenceLength();
        int fences = Parsing.skip(fenceChar, line2, index2, line2.length()) - index2;
        if (fences < fenceLength) {
            return false;
        }
        int after = Parsing.skipSpaceTab(line2, index2 + fences, line2.length());
        return after == line2.length();
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            int indent = state.getIndent();
            if (indent >= Parsing.CODE_BLOCK_INDENT) {
                return BlockStart.none();
            }
            int nextNonSpace = state.getNextNonSpaceIndex();
            FencedCodeBlockParser blockParser = FencedCodeBlockParser.checkOpener(state.getLine().getContent(), nextNonSpace, indent);
            if (blockParser != null) {
                return BlockStart.of(blockParser).atIndex(nextNonSpace + blockParser.block.getFenceLength());
            }
            return BlockStart.none();
        }
    }
}

