/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.font.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import gg.essential.elementa.font.data.FontInfo;
import gg.essential.universal.UGraphics;
import gg.essential.universal.utils.ReleasedDynamicTexture;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u00020\u00028\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lgg/essential/elementa/font/data/Font;", "", "Lgg/essential/universal/utils/ReleasedDynamicTexture;", "getTexture", "()Lgg/essential/universal/utils/ReleasedDynamicTexture;", "Ljava/io/InputStream;", "atlas", "Ljava/io/InputStream;", "Lgg/essential/elementa/font/data/FontInfo;", "fontInfo", "Lgg/essential/elementa/font/data/FontInfo;", "getFontInfo", "()Lgg/essential/elementa/font/data/FontInfo;", "texture", "Lgg/essential/universal/utils/ReleasedDynamicTexture;", "<init>", "(Lgg/essential/elementa/font/data/FontInfo;Ljava/io/InputStream;)V", "Companion", "Elementa"})
public final class Font {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FontInfo fontInfo;
    @NotNull
    private final InputStream atlas;
    private ReleasedDynamicTexture texture;

    public Font(@NotNull FontInfo fontInfo, @NotNull InputStream atlas) {
        Intrinsics.checkNotNullParameter(fontInfo, "fontInfo");
        Intrinsics.checkNotNullParameter(atlas, "atlas");
        this.fontInfo = fontInfo;
        this.atlas = atlas;
    }

    @NotNull
    public final FontInfo getFontInfo() {
        return this.fontInfo;
    }

    @NotNull
    public final ReleasedDynamicTexture getTexture() {
        ReleasedDynamicTexture releasedDynamicTexture;
        if (this.texture == null) {
            ReleasedDynamicTexture releasedDynamicTexture2 = UGraphics.getTexture(this.atlas);
            Intrinsics.checkNotNullExpressionValue((Object)releasedDynamicTexture2, "getTexture(atlas)");
            this.texture = releasedDynamicTexture2;
        }
        if ((releasedDynamicTexture = this.texture) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("texture");
            releasedDynamicTexture = null;
        }
        return releasedDynamicTexture;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lgg/essential/elementa/font/data/Font$Companion;", "", "", "path", "Lgg/essential/elementa/font/data/Font;", "fromResource", "(Ljava/lang/String;)Lgg/essential/elementa/font/data/Font;", "<init>", "()V", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Font fromResource(@NotNull String path) {
            Intrinsics.checkNotNullParameter(path, "path");
            InputStream json2 = this.getClass().getResourceAsStream(Intrinsics.stringPlus(path, ".json"));
            JsonParser jsonParser = new JsonParser();
            Intrinsics.checkNotNullExpressionValue(json2, "json");
            InputStream inputStream = json2;
            Charset charset = Charsets.UTF_8;
            Object object = jsonParser.parse((Reader)new InputStreamReader(inputStream, charset)).getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue(object, "JsonParser().parse(json.reader()).asJsonObject");
            FontInfo fontInfo = FontInfo.Companion.fromJson((JsonObject)object);
            object = this.getClass().getResourceAsStream(Intrinsics.stringPlus(path, ".png"));
            Intrinsics.checkNotNullExpressionValue(object, "this::class.java.getResourceAsStream(\"$path.png\")");
            return new Font(fontInfo, (InputStream)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

