/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.effects;

import gg.essential.elementa.components.UIBlock;
import gg.essential.elementa.effects.Effect;
import gg.essential.elementa.state.BasicState;
import gg.essential.elementa.state.State;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\"\n\u0002\b\u0010\u0018\u00002\u00020\u0001:\u0001:B=\b\u0007\u0012\u0006\u0010\u001a\u001a\u00020\r\u0012\u0006\u00106\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u001e\u001a\u00020\u001d\u0012\b\b\u0002\u0010$\u001a\u00020\u001d\u0012\u000e\b\u0002\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020+\u00a2\u0006\u0004\b8\u00109J\u0015\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000b\u0010\nJ\u001b\u0010\u000f\u001a\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001b\u0010\u0012\u001a\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00110\f\u00a2\u0006\u0004\b\u0012\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0013\u0010\nJ\u0015\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0005R$\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\"\u0010\u001e\u001a\u00020\u001d8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\"\u0010$\u001a\u00020\u001d8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010\u001f\u001a\u0004\b%\u0010!\"\u0004\b&\u0010#R\u0016\u0010'\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010\u001fR\u0016\u0010(\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010\u001fR\u0016\u0010)\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010\u001fR\u0016\u0010*\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010\u001fR6\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020+2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020+8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R$\u00106\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001c\u00107\u001a\b\u0012\u0004\u0012\u00020\u00110\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u0010\u001c\u00a8\u0006;"}, d2={"Lgg/essential/elementa/effects/OutlineEffect;", "Lgg/essential/elementa/effects/Effect;", "Lgg/essential/elementa/effects/OutlineEffect$Side;", "side", "addSide", "(Lgg/essential/elementa/effects/OutlineEffect$Side;)Lgg/essential/elementa/effects/OutlineEffect;", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "", "afterDraw", "(Lgg/essential/universal/UMatrixStack;)V", "beforeChildrenDraw", "Lgg/essential/elementa/state/State;", "Ljava/awt/Color;", "state", "bindColor", "(Lgg/essential/elementa/state/State;)Lgg/essential/elementa/effects/OutlineEffect;", "", "bindWidth", "drawOutline", "removeSide", "value", "getColor", "()Ljava/awt/Color;", "setColor", "(Ljava/awt/Color;)V", "color", "colorState", "Lgg/essential/elementa/state/State;", "", "drawAfterChildren", "Z", "getDrawAfterChildren", "()Z", "setDrawAfterChildren", "(Z)V", "drawInsideChildren", "getDrawInsideChildren", "setDrawInsideChildren", "hasBottom", "hasLeft", "hasRight", "hasTop", "", "sides", "Ljava/util/Set;", "getSides", "()Ljava/util/Set;", "setSides", "(Ljava/util/Set;)V", "getWidth", "()F", "setWidth", "(F)V", "width", "widthState", "<init>", "(Ljava/awt/Color;FZZLjava/util/Set;)V", "Side", "Elementa"})
public final class OutlineEffect
extends Effect {
    private boolean drawAfterChildren;
    private boolean drawInsideChildren;
    private boolean hasLeft;
    private boolean hasTop;
    private boolean hasRight;
    private boolean hasBottom;
    @NotNull
    private State<Color> colorState;
    @NotNull
    private State<Float> widthState;
    @NotNull
    private Set<? extends Side> sides;

    @JvmOverloads
    public OutlineEffect(@NotNull Color color, float width, boolean drawAfterChildren, boolean drawInsideChildren, @NotNull Set<? extends Side> sides) {
        Intrinsics.checkNotNullParameter(color, "color");
        Intrinsics.checkNotNullParameter(sides, "sides");
        this.drawAfterChildren = drawAfterChildren;
        this.drawInsideChildren = drawInsideChildren;
        this.hasLeft = sides.contains((Object)Side.Left);
        this.hasTop = sides.contains((Object)Side.Top);
        this.hasRight = sides.contains((Object)Side.Right);
        this.hasBottom = sides.contains((Object)Side.Bottom);
        this.colorState = new BasicState<Color>(color);
        this.widthState = new BasicState<Float>(Float.valueOf(width));
        this.sides = sides;
    }

    public /* synthetic */ OutlineEffect(Color color, float f, boolean bl, boolean bl2, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            Side[] sideArray = new Side[]{Side.Left, Side.Top, Side.Right, Side.Bottom};
            set = SetsKt.setOf(sideArray);
        }
        this(color, f, bl, bl2, (Set<? extends Side>)set);
    }

    public final boolean getDrawAfterChildren() {
        return this.drawAfterChildren;
    }

    public final void setDrawAfterChildren(boolean bl) {
        this.drawAfterChildren = bl;
    }

    public final boolean getDrawInsideChildren() {
        return this.drawInsideChildren;
    }

    public final void setDrawInsideChildren(boolean bl) {
        this.drawInsideChildren = bl;
    }

    @NotNull
    public final Color getColor() {
        return this.colorState.get();
    }

    public final void setColor(@NotNull Color value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        this.colorState.set(value2);
    }

    public final float getWidth() {
        return ((Number)this.widthState.get()).floatValue();
    }

    public final void setWidth(float value2) {
        this.widthState.set(Float.valueOf(value2));
    }

    @NotNull
    public final OutlineEffect bindColor(@NotNull State<Color> state) {
        OutlineEffect outlineEffect;
        Intrinsics.checkNotNullParameter(state, "state");
        OutlineEffect $this$bindColor_u24lambda_u2d0 = outlineEffect = this;
        boolean bl = false;
        $this$bindColor_u24lambda_u2d0.colorState = state;
        return outlineEffect;
    }

    @NotNull
    public final OutlineEffect bindWidth(@NotNull State<Float> state) {
        OutlineEffect outlineEffect;
        Intrinsics.checkNotNullParameter(state, "state");
        OutlineEffect $this$bindWidth_u24lambda_u2d1 = outlineEffect = this;
        boolean bl = false;
        $this$bindWidth_u24lambda_u2d1.widthState = state;
        return outlineEffect;
    }

    @NotNull
    public final Set<Side> getSides() {
        return this.sides;
    }

    public final void setSides(@NotNull Set<? extends Side> value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        this.sides = value2;
        this.hasLeft = this.sides.contains((Object)Side.Left);
        this.hasTop = this.sides.contains((Object)Side.Top);
        this.hasRight = this.sides.contains((Object)Side.Right);
        this.hasBottom = this.sides.contains((Object)Side.Bottom);
    }

    @NotNull
    public final OutlineEffect addSide(@NotNull Side side) {
        OutlineEffect outlineEffect;
        Intrinsics.checkNotNullParameter((Object)side, "side");
        OutlineEffect $this$addSide_u24lambda_u2d2 = outlineEffect = this;
        boolean bl = false;
        $this$addSide_u24lambda_u2d2.setSides(SetsKt.plus($this$addSide_u24lambda_u2d2.getSides(), side));
        return outlineEffect;
    }

    @NotNull
    public final OutlineEffect removeSide(@NotNull Side side) {
        OutlineEffect outlineEffect;
        Intrinsics.checkNotNullParameter((Object)side, "side");
        OutlineEffect $this$removeSide_u24lambda_u2d3 = outlineEffect = this;
        boolean bl = false;
        $this$removeSide_u24lambda_u2d3.setSides(SetsKt.minus($this$removeSide_u24lambda_u2d3.getSides(), side));
        return outlineEffect;
    }

    @Override
    public void beforeChildrenDraw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        if (!this.drawAfterChildren) {
            this.drawOutline(matrixStack);
        }
    }

    @Override
    public void afterDraw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        if (this.drawAfterChildren) {
            this.drawOutline(matrixStack);
        }
    }

    private final void drawOutline(UMatrixStack matrixStack) {
        Pair<Double, Double> bottomBounds;
        Color color = this.colorState.get();
        float width = ((Number)this.widthState.get()).floatValue();
        double left2 = this.getBoundComponent().getLeft();
        double right = this.getBoundComponent().getRight();
        double top = this.getBoundComponent().getTop();
        double bottom = this.getBoundComponent().getBottom();
        Pair<Double, Double> leftBounds = this.drawInsideChildren ? TuplesKt.to(left2, left2 + (double)width) : TuplesKt.to(left2 - (double)width, left2);
        Pair<Double, Double> topBounds = this.drawInsideChildren ? TuplesKt.to(top, top + (double)width) : TuplesKt.to(top - (double)width, top);
        Pair<Double, Double> rightBounds = this.drawInsideChildren ? TuplesKt.to(right - (double)width, right) : TuplesKt.to(right, right + (double)width);
        Pair<Double, Double> pair = bottomBounds = this.drawInsideChildren ? TuplesKt.to(bottom - (double)width, bottom) : TuplesKt.to(bottom, bottom + (double)width);
        if (this.hasLeft) {
            UIBlock.Companion.drawBlock(matrixStack, color, ((Number)leftBounds.getFirst()).doubleValue(), top, ((Number)leftBounds.getSecond()).doubleValue(), bottom);
        }
        if (this.hasTop) {
            UIBlock.Companion.drawBlock(matrixStack, color, left2, ((Number)topBounds.getFirst()).doubleValue(), right, ((Number)topBounds.getSecond()).doubleValue());
        }
        if (this.hasRight) {
            UIBlock.Companion.drawBlock(matrixStack, color, ((Number)rightBounds.getFirst()).doubleValue(), top, ((Number)rightBounds.getSecond()).doubleValue(), bottom);
        }
        if (this.hasBottom) {
            UIBlock.Companion.drawBlock(matrixStack, color, left2, ((Number)bottomBounds.getFirst()).doubleValue(), right, ((Number)bottomBounds.getSecond()).doubleValue());
        }
        if (!this.drawInsideChildren) {
            if (this.hasLeft && this.hasTop) {
                UIBlock.Companion.drawBlock(matrixStack, color, ((Number)leftBounds.getFirst()).doubleValue(), ((Number)topBounds.getFirst()).doubleValue(), left2, top);
            }
            if (this.hasRight && this.hasTop) {
                UIBlock.Companion.drawBlock(matrixStack, color, right, ((Number)topBounds.getFirst()).doubleValue(), ((Number)rightBounds.getSecond()).doubleValue(), top);
            }
            if (this.hasRight && this.hasBottom) {
                UIBlock.Companion.drawBlock(matrixStack, color, right, bottom, ((Number)rightBounds.getSecond()).doubleValue(), ((Number)bottomBounds.getSecond()).doubleValue());
            }
            if (this.hasBottom && this.hasLeft) {
                UIBlock.Companion.drawBlock(matrixStack, color, ((Number)leftBounds.getFirst()).doubleValue(), bottom, left2, ((Number)bottomBounds.getSecond()).doubleValue());
            }
        }
    }

    @JvmOverloads
    public OutlineEffect(@NotNull Color color, float width, boolean drawAfterChildren, boolean drawInsideChildren) {
        Intrinsics.checkNotNullParameter(color, "color");
        this(color, width, drawAfterChildren, drawInsideChildren, null, 16, null);
    }

    @JvmOverloads
    public OutlineEffect(@NotNull Color color, float width, boolean drawAfterChildren) {
        Intrinsics.checkNotNullParameter(color, "color");
        this(color, width, drawAfterChildren, false, null, 24, null);
    }

    @JvmOverloads
    public OutlineEffect(@NotNull Color color, float width) {
        Intrinsics.checkNotNullParameter(color, "color");
        this(color, width, false, false, null, 28, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lgg/essential/elementa/effects/OutlineEffect$Side;", "", "<init>", "(Ljava/lang/String;I)V", "Left", "Top", "Right", "Bottom", "Elementa"})
    public static final class Side
    extends Enum<Side> {
        public static final /* enum */ Side Left = new Side();
        public static final /* enum */ Side Top = new Side();
        public static final /* enum */ Side Right = new Side();
        public static final /* enum */ Side Bottom = new Side();
        private static final /* synthetic */ Side[] $VALUES;

        public static Side[] values() {
            return (Side[])$VALUES.clone();
        }

        public static Side valueOf(String value2) {
            return Enum.valueOf(Side.class, value2);
        }

        static {
            $VALUES = sideArray = new Side[]{Side.Left, Side.Top, Side.Right, Side.Bottom};
        }
    }
}

