/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.constraints.resolution;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.constraints.ConstraintType;
import gg.essential.elementa.constraints.SuperConstraint;
import gg.essential.elementa.constraints.resolution.ConstraintResolverKt;
import gg.essential.elementa.constraints.resolution.ConstraintVisitor;
import gg.essential.elementa.constraints.resolution.DirectedAcyclicGraph;
import gg.essential.elementa.constraints.resolution.ResolverNode;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lgg/essential/elementa/constraints/resolution/ConstraintResolver;", "", "", "Lgg/essential/elementa/constraints/resolution/ResolverNode;", "getCyclicNodes", "()Ljava/util/List;", "Lgg/essential/elementa/constraints/resolution/DirectedAcyclicGraph;", "graph", "Lgg/essential/elementa/constraints/resolution/DirectedAcyclicGraph;", "Lgg/essential/elementa/components/Window;", "window", "<init>", "(Lgg/essential/elementa/components/Window;)V", "Elementa"})
public final class ConstraintResolver {
    @NotNull
    private final DirectedAcyclicGraph<ResolverNode> graph;

    public ConstraintResolver(@NotNull Window window) {
        Intrinsics.checkNotNullParameter(window, "window");
        this.graph = new DirectedAcyclicGraph();
        ConstraintResolverKt.forEachChild(window, (Function1<? super UIComponent, Unit>)new Function1<UIComponent, Unit>(){

            @Override
            public final void invoke(@NotNull UIComponent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                ResolverNode[] resolverNodeArray = new ResolverNode[]{new ResolverNode(it, it.getConstraints().getX(), ConstraintType.X), new ResolverNode(it, it.getConstraints().getY(), ConstraintType.Y), new ResolverNode(it, it.getConstraints().getWidth(), ConstraintType.WIDTH), new ResolverNode(it, it.getConstraints().getHeight(), ConstraintType.HEIGHT), new ResolverNode(it, it.getConstraints().getTextScale(), ConstraintType.TEXT_SCALE), new ResolverNode(it, it.getConstraints().getRadius(), ConstraintType.RADIUS)};
                graph.addVertices(resolverNodeArray);
            }
        });
        ConstraintResolverKt.forEachChild(window, (Function1<? super UIComponent, Unit>)new Function1<UIComponent, Unit>(){

            @Override
            public final void invoke(@NotNull UIComponent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                ConstraintVisitor visitor2 = new ConstraintVisitor(graph, it);
                SuperConstraint.visit$default(it.getConstraints().getX(), visitor2, ConstraintType.X, false, 4, null);
                SuperConstraint.visit$default(it.getConstraints().getY(), visitor2, ConstraintType.Y, false, 4, null);
                SuperConstraint.visit$default(it.getConstraints().getWidth(), visitor2, ConstraintType.WIDTH, false, 4, null);
                SuperConstraint.visit$default(it.getConstraints().getHeight(), visitor2, ConstraintType.HEIGHT, false, 4, null);
                SuperConstraint.visit$default(it.getConstraints().getTextScale(), visitor2, ConstraintType.TEXT_SCALE, false, 4, null);
                SuperConstraint.visit$default(it.getConstraints().getRadius(), visitor2, ConstraintType.RADIUS, false, 4, null);
            }
        });
    }

    @Nullable
    public final List<ResolverNode> getCyclicNodes() {
        return this.graph.getCyclicLoop();
    }
}

