/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.constraints;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.constraints.ConstraintType;
import gg.essential.elementa.constraints.PositionConstraint;
import gg.essential.elementa.constraints.SizeConstraint;
import gg.essential.elementa.constraints.SuperConstraint;
import gg.essential.elementa.constraints.resolution.ConstraintVisitor;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u0002B\u0013\b\u0007\u0012\b\b\u0002\u0010*\u001a\u00020\b\u00a2\u0006\u0004\b-\u0010\u001dJ\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0017\u0010\f\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\f\u0010\nJ\u0017\u0010\r\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\r\u0010\nJ\u0017\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u000e\u0010\nJ\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\u00020\b8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\u0004\u0018\u00010\u00038\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010\u0007R\"\u0010$\u001a\u00020#8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0017\u0010*\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b*\u0010\u0019\u001a\u0004\b+\u0010,\u00a8\u0006."}, d2={"Lgg/essential/elementa/constraints/RelativeWindowConstraint;", "Lgg/essential/elementa/constraints/PositionConstraint;", "Lgg/essential/elementa/constraints/SizeConstraint;", "Lgg/essential/elementa/UIComponent;", "component", "", "ensureConstrainedToWindow", "(Lgg/essential/elementa/UIComponent;)V", "", "getHeightImpl", "(Lgg/essential/elementa/UIComponent;)F", "getRadiusImpl", "getWidthImpl", "getXPositionImpl", "getYPositionImpl", "Lgg/essential/elementa/constraints/SuperConstraint;", "to", "(Lgg/essential/elementa/UIComponent;)Lgg/essential/elementa/constraints/SuperConstraint;", "Lgg/essential/elementa/constraints/resolution/ConstraintVisitor;", "visitor", "Lgg/essential/elementa/constraints/ConstraintType;", "type", "visitImpl", "(Lgg/essential/elementa/constraints/resolution/ConstraintVisitor;Lgg/essential/elementa/constraints/ConstraintType;)V", "cachedValue", "F", "getCachedValue", "()Ljava/lang/Float;", "setCachedValue", "(F)V", "constrainTo", "Lgg/essential/elementa/UIComponent;", "getConstrainTo", "()Lgg/essential/elementa/UIComponent;", "setConstrainTo", "", "recalculate", "Z", "getRecalculate", "()Z", "setRecalculate", "(Z)V", "value", "getValue", "()F", "<init>", "Elementa"})
public final class RelativeWindowConstraint
implements PositionConstraint,
SizeConstraint {
    private final float value;
    private float cachedValue;
    private boolean recalculate;
    @Nullable
    private UIComponent constrainTo;

    @JvmOverloads
    public RelativeWindowConstraint(float value2) {
        this.value = value2;
        this.recalculate = true;
    }

    public /* synthetic */ RelativeWindowConstraint(float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        this(f);
    }

    public final float getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public Float getCachedValue() {
        return Float.valueOf(this.cachedValue);
    }

    @Override
    public void setCachedValue(float f) {
        this.cachedValue = f;
    }

    @Override
    public boolean getRecalculate() {
        return this.recalculate;
    }

    @Override
    public void setRecalculate(boolean bl) {
        this.recalculate = bl;
    }

    @Override
    @Nullable
    public UIComponent getConstrainTo() {
        return this.constrainTo;
    }

    @Override
    public void setConstrainTo(@Nullable UIComponent uIComponent) {
        this.constrainTo = uIComponent;
    }

    @Override
    public float getXPositionImpl(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter(component2, "component");
        this.ensureConstrainedToWindow(component2);
        UIComponent uIComponent = this.getConstrainTo();
        Intrinsics.checkNotNull(uIComponent);
        return uIComponent.getLeft() + this.getWidth(component2);
    }

    @Override
    public float getYPositionImpl(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter(component2, "component");
        this.ensureConstrainedToWindow(component2);
        UIComponent uIComponent = this.getConstrainTo();
        Intrinsics.checkNotNull(uIComponent);
        return uIComponent.getTop() + this.getHeight(component2);
    }

    @Override
    public float getWidthImpl(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter(component2, "component");
        this.ensureConstrainedToWindow(component2);
        UIComponent uIComponent = this.getConstrainTo();
        Intrinsics.checkNotNull(uIComponent);
        return uIComponent.getWidth() * this.value;
    }

    @Override
    public float getHeightImpl(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter(component2, "component");
        this.ensureConstrainedToWindow(component2);
        UIComponent uIComponent = this.getConstrainTo();
        Intrinsics.checkNotNull(uIComponent);
        return uIComponent.getHeight() * this.value;
    }

    @Override
    public float getRadiusImpl(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter(component2, "component");
        this.ensureConstrainedToWindow(component2);
        UIComponent uIComponent = this.getConstrainTo();
        Intrinsics.checkNotNull(uIComponent);
        return uIComponent.getWidth() * this.value / 2.0f;
    }

    @Override
    @NotNull
    public SuperConstraint<Float> to(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter(component2, "component");
        throw new IllegalStateException("RelativeWindowConstraint cannot be bound to components");
    }

    @Override
    public void visitImpl(@NotNull ConstraintVisitor visitor2, @NotNull ConstraintType type2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
    }

    private final void ensureConstrainedToWindow(UIComponent component2) {
        if (this.getConstrainTo() == null) {
            this.setConstrainTo(Window.Companion.of(component2));
        }
    }

    @JvmOverloads
    public RelativeWindowConstraint() {
        this(0.0f, 1, null);
    }
}

