/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.components.image;

import gg.essential.elementa.components.image.ImageCache;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010*\u001a\u00020\r\u0012\u0006\u0010%\u001a\u00020\u0011\u0012\u0006\u0010-\u001a\u00020,\u0012\b\b\u0002\u0010(\u001a\u00020'\u00a2\u0006\u0004\b/\u00100J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ)\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J \u0010\u0015\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0004H\u0096\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0019\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001d\u0010 \u001a\u0004\u0018\u00010\u0010*\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b \u0010!J\u001d\u0010#\u001a\u0004\u0018\u00010\u0010*\u00020\u001a2\u0006\u0010\"\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0014\u0010-\u001a\u00020,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.\u00a8\u00061"}, d2={"Lgg/essential/elementa/components/image/FileImageCache;", "Lgg/essential/elementa/components/image/ImageCache;", "Ljava/net/URL;", "url", "Ljava/awt/image/BufferedImage;", "get", "(Ljava/net/URL;)Ljava/awt/image/BufferedImage;", "", "hashCode", "index", "", "moveDown", "(II)V", "Ljava/io/File;", "file", "Lkotlin/Triple;", "", "", "readEntry", "(Ljava/io/File;)Lkotlin/Triple;", "image", "set", "(Ljava/net/URL;Ljava/awt/image/BufferedImage;)V", "img", "writeEntry", "(Ljava/io/File;Ljava/awt/image/BufferedImage;Ljava/net/URL;)V", "Lorg/w3c/dom/NodeList;", "Lkotlin/sequences/Sequence;", "Lorg/w3c/dom/Node;", "asSequence", "(Lorg/w3c/dom/NodeList;)Lkotlin/sequences/Sequence;", "name", "attributeValue", "(Lorg/w3c/dom/Node;Ljava/lang/String;)Ljava/lang/String;", "keyword", "findValueByKeyword", "(Lorg/w3c/dom/NodeList;Ljava/lang/String;)Ljava/lang/String;", "cacheTime", "J", "", "deleteOnCacheMiss", "Z", "directory", "Ljava/io/File;", "Ljava/util/concurrent/TimeUnit;", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "<init>", "(Ljava/io/File;JLjava/util/concurrent/TimeUnit;Z)V", "Elementa"})
public final class FileImageCache
implements ImageCache {
    @NotNull
    private final File directory;
    private final long cacheTime;
    @NotNull
    private final TimeUnit timeUnit;
    private final boolean deleteOnCacheMiss;

    public FileImageCache(@NotNull File directory, long cacheTime, @NotNull TimeUnit timeUnit, boolean deleteOnCacheMiss) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter((Object)timeUnit, "timeUnit");
        this.directory = directory;
        this.cacheTime = cacheTime;
        this.timeUnit = timeUnit;
        this.deleteOnCacheMiss = deleteOnCacheMiss;
        if (!this.directory.exists()) {
            this.directory.mkdirs();
        }
        if (!this.directory.isDirectory()) {
            throw new IllegalArgumentException("Directory " + this.directory.getAbsolutePath() + " is not a valid directory for a FileImageCache");
        }
    }

    public /* synthetic */ FileImageCache(File file, long l, TimeUnit timeUnit, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(file, l, timeUnit, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public BufferedImage get(@NotNull URL url) {
        Intrinsics.checkNotNullParameter(url, "url");
        hashCode = url.hashCode();
        index = 0;
        var4_4 = FileChannel.open(new File(this.directory, "" + hashCode + '-' + index + ".png").toPath(), new OpenOption[0]);
        var5_5 = null;
        try {
            open = (FileChannel)var4_4;
            $i$a$-use-FileImageCache$get$1 = false;
            lock = open.lock();
            while (true) {
                if (!(file = new File(this.directory, "" + hashCode + '-' + index + ".png")).exists()) {
                    lock.release();
                    var13_14 = null;
                    return var13_14;
                }
                cacheItem = this.readEntry(file);
                if (!Intrinsics.areEqual(cacheItem.getSecond(), url.toString())) ** GOTO lbl28
                if (System.currentTimeMillis() - ((Number)cacheItem.getThird()).longValue() < this.timeUnit.toMillis(this.cacheTime)) {
                    lock.release();
                    var12_15 = cacheItem.getFirst();
                    return var12_15;
                }
                if (this.deleteOnCacheMiss) {
                    file.delete();
                    this.moveDown(hashCode, index);
                }
lbl28:
                // 4 sources

                var11_13 = index;
                index = var11_13 + 1;
                continue;
                break;
            }
            catch (Throwable var6_7) {
                var5_5 = var6_7;
                throw var6_7;
            }
        }
        finally {
            CloseableKt.closeFinally(var4_4, var5_5);
        }
    }

    @Override
    public void set(@NotNull URL url, @NotNull BufferedImage image2) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(image2, "image");
        int hashCode2 = url.hashCode();
        int index2 = 0;
        while (true) {
            File file;
            if (!(file = new File(this.directory, "" + hashCode2 + '-' + index2 + ".png")).exists()) {
                this.writeEntry(file, image2, url);
                return;
            }
            int n = index2;
            index2 = n + 1;
        }
    }

    private final void moveDown(int hashCode2, int index2) {
        int tmp = index2 + 1;
        File src;
        while ((src = new File(this.directory, "" + hashCode2 + '-' + tmp + ".png")).exists()) {
            src.renameTo(new File(this.directory, "" + hashCode2 + '-' + (tmp - 1) + ".png"));
            int n = tmp;
            tmp = n + 1;
        }
        return;
    }

    private final void writeEntry(File file, BufferedImage img, URL url) {
        ImageWriter writer = ImageIO.getImageWritersByFormatName("png").next();
        ImageWriteParam writeParam = writer.getDefaultWriteParam();
        ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
        IIOMetadata metadata2 = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
        IIOMetadataNode urlEntry = new IIOMetadataNode("tEXtEntry");
        urlEntry.setAttribute("keyword", "image_url");
        urlEntry.setAttribute("value", url.toString());
        IIOMetadataNode cacheTimeEntry = new IIOMetadataNode("tEXtEntry");
        cacheTimeEntry.setAttribute("keyword", "cache_time");
        cacheTimeEntry.setAttribute("value", String.valueOf(System.currentTimeMillis()));
        IIOMetadataNode text = new IIOMetadataNode("tEXt");
        text.appendChild(urlEntry);
        text.appendChild(cacheTimeEntry);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_png_1.0");
        root.appendChild(text);
        metadata2.mergeTree("javax_imageio_png_1.0", root);
        FileOutputStream fos = new FileOutputStream(file);
        ImageOutputStream stream = ImageIO.createImageOutputStream(fos);
        writer.setOutput(stream);
        writer.write(metadata2, new IIOImage(img, null, metadata2), writeParam);
        stream.close();
        fos.close();
    }

    private final Triple<BufferedImage, String, Long> readEntry(File file) {
        long l;
        Node node2;
        Object object;
        byte[] imageData;
        block2: {
            ImageReader imageReader = ImageIO.getImageReadersByFormatName("png").next();
            imageData = FilesKt.readBytes(file);
            imageReader.setInput(ImageIO.createImageInputStream(new ByteArrayInputStream(imageData)), true);
            Node metadata2 = imageReader.getImageMetadata(0).getAsTree("javax_imageio_1.0");
            NodeList nodeList = metadata2.getChildNodes();
            Intrinsics.checkNotNullExpressionValue(nodeList, "metadata.childNodes");
            object = this.asSequence(nodeList).iterator();
            while (object.hasNext()) {
                Node node3;
                Node it = node3 = object.next();
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getNodeName(), "Text")) continue;
                node2 = node3;
                break block2;
            }
            node2 = null;
        }
        Intrinsics.checkNotNull(node2);
        NodeList nodeList = ((Node)node2).getChildNodes();
        Intrinsics.checkNotNullExpressionValue(nodeList, "metadata.childNodes.asSe\u2026 == \"Text\" }!!.childNodes");
        NodeList childNodes = nodeList;
        String string = this.findValueByKeyword(childNodes, "image_url");
        if (string == null) {
            string = "";
        }
        String cacheUrl = string;
        object = this.findValueByKeyword(childNodes, "cache_time");
        long timeCached = object == null ? 0L : (l = Long.parseLong((String)object));
        return new Triple<BufferedImage, String, Long>(ImageIO.read(new ByteArrayInputStream(imageData)), cacheUrl, timeCached);
    }

    private final Sequence<Node> asSequence(NodeList $this$asSequence) {
        return SequencesKt.map(CollectionsKt.asSequence(RangesKt.until(0, $this$asSequence.getLength())), (Function1)new Function1<Integer, Node>($this$asSequence){
            final /* synthetic */ NodeList $this_asSequence;
            {
                this.$this_asSequence = $receiver;
                super(1);
            }

            public final Node invoke(int it) {
                return this.$this_asSequence.item(it);
            }
        });
    }

    private final String attributeValue(Node $this$attributeValue, String name) {
        Node node2 = $this$attributeValue.getAttributes().getNamedItem(name);
        return node2 == null ? null : node2.getNodeValue();
    }

    private final String findValueByKeyword(NodeList $this$findValueByKeyword, String keyword) {
        Node node2;
        block1: {
            Iterator<Node> iterator2 = this.asSequence($this$findValueByKeyword).iterator();
            while (iterator2.hasNext()) {
                Node node3;
                Node it = node3 = iterator2.next();
                boolean bl = false;
                if (!Intrinsics.areEqual(this.attributeValue(it, "keyword"), keyword)) continue;
                node2 = node3;
                break block1;
            }
            node2 = null;
        }
        Node node4 = node2;
        return node4 == null ? null : this.attributeValue(node4, "value");
    }
}

