/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.components;

import gg.essential.elementa.ElementaVersion;
import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.constraints.resolution.ConstraintResolutionGui;
import gg.essential.elementa.constraints.resolution.ConstraintResolver;
import gg.essential.elementa.constraints.resolution.ConstraintResolverV2;
import gg.essential.elementa.constraints.resolution.ResolverNode;
import gg.essential.elementa.effects.ScissorEffect;
import gg.essential.elementa.impl.Platform;
import gg.essential.elementa.utils.InvalidUsageKt;
import gg.essential.elementa.utils.OptionsKt;
import gg.essential.universal.UChat;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UResolution;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 Y2\u00020\u0001:\u0001YB\u0013\b\u0017\u0012\b\b\u0002\u00104\u001a\u00020%\u00a2\u0006\u0004\bV\u0010WB\u001b\b\u0007\u0012\u0006\u0010T\u001a\u00020S\u0012\b\b\u0002\u00104\u001a\u00020%\u00a2\u0006\u0004\bV\u0010XJ\u0015\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\b\u0010\u0007J\u000f\u0010\t\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\t\u0010\u0007J\u0017\u0010\f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\nH\u0000\u00a2\u0006\u0004\b\u000f\u0010\rJ\u000f\u0010\u0011\u001a\u00020\u0003H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0007J\u0015\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0011\u0010\rJ\u0015\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0005J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0015J\u000f\u0010\u0018\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0015J\u000f\u0010\u0019\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0015J\u000f\u0010\u001a\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0015J-\u0010!\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001b\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010'\u001a\u00020\u00032\u0006\u0010$\u001a\u00020#2\u0006\u0010&\u001a\u00020%H\u0016\u00a2\u0006\u0004\b'\u0010(J'\u0010,\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020%H\u0016\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010.\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b.\u0010\u0007J\u0017\u00100\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b0\u00101J\u0015\u00102\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b2\u0010\u0005J\r\u00103\u001a\u00020\u0003\u00a2\u0006\u0004\b3\u0010\u0007R\u0017\u00104\u001a\u00020%8\u0006\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b6\u00107R\u0016\u00108\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109Ri\u0010=\u001aI\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b()\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b(*\u0012\u0013\u0012\u00110%\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020 \u0018\u00010:8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u0018\u0010C\u001a\u0004\u0018\u00010\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bC\u0010DR\u0016\u0010E\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bE\u00105R\u001c\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00010F8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bG\u0010HR(\u0010J\u001a\u0004\u0018\u00010\u00012\b\u0010I\u001a\u0004\u0018\u00010\u00018\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bJ\u0010D\u001a\u0004\bK\u0010LR$\u0010M\u001a\u0004\u0018\u00010\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bM\u0010D\u001a\u0004\bN\u0010L\"\u0004\bO\u0010\u0005R\u0016\u0010Q\u001a\u00020P8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bQ\u0010RR\u0014\u0010T\u001a\u00020S8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bT\u0010U\u00a8\u0006Z"}, d2={"Lgg/essential/elementa/components/Window;", "Lgg/essential/elementa/UIComponent;", "component", "", "addFloatingComponent", "(Lgg/essential/elementa/UIComponent;)V", "afterInitialization", "()V", "animationFrame", "dealWithFocusRequests", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "doDraw", "(Lgg/essential/universal/UMatrixStack;)V", "draw", "drawEmbedded$Elementa", "drawEmbedded", "drawFloatingComponents", "focus", "", "getBottom", "()F", "getHeight", "getLeft", "getRight", "getTop", "getWidth", "", "left", "top", "right", "bottom", "", "isAreaVisible", "(DDDD)Z", "", "typedChar", "", "keyCode", "keyType", "(CI)V", "mouseX", "mouseY", "button", "mouseClick", "(DDI)V", "mouseRelease", "delta", "mouseScroll", "(D)V", "removeFloatingComponent", "unfocus", "animationFPS", "I", "getAnimationFPS", "()I", "cancelDrawing", "Z", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "clickInterceptor", "Lkotlin/jvm/functions/Function3;", "getClickInterceptor$Elementa", "()Lkotlin/jvm/functions/Function3;", "setClickInterceptor$Elementa", "(Lkotlin/jvm/functions/Function3;)V", "componentRequestingFocus", "Lgg/essential/elementa/UIComponent;", "currentMouseButton", "", "floatingComponents", "Ljava/util/List;", "<set-?>", "focusedComponent", "getFocusedComponent", "()Lgg/essential/elementa/UIComponent;", "hoveredFloatingComponent", "getHoveredFloatingComponent", "setHoveredFloatingComponent", "", "systemTime", "J", "Lgg/essential/elementa/ElementaVersion;", "version", "Lgg/essential/elementa/ElementaVersion;", "<init>", "(I)V", "(Lgg/essential/elementa/ElementaVersion;I)V", "Companion", "Elementa"})
public final class Window
extends UIComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ElementaVersion version;
    private final int animationFPS;
    private long systemTime;
    private int currentMouseButton;
    @NotNull
    private List<UIComponent> floatingComponents;
    @Nullable
    private UIComponent hoveredFloatingComponent;
    @Nullable
    private UIComponent focusedComponent;
    @Nullable
    private UIComponent componentRequestingFocus;
    private boolean cancelDrawing;
    @Nullable
    private Function3<? super Double, ? super Double, ? super Integer, Boolean> clickInterceptor;
    @NotNull
    private static final ConcurrentLinkedQueue<Function0<Unit>> renderOperations = new ConcurrentLinkedQueue();

    @JvmOverloads
    public Window(@NotNull ElementaVersion version, int animationFPS) {
        Intrinsics.checkNotNullParameter((Object)version, "version");
        this.version = version;
        this.animationFPS = animationFPS;
        this.systemTime = -1L;
        this.currentMouseButton = -1;
        this.floatingComponents = new ArrayList();
        super.setParent(this);
    }

    public /* synthetic */ Window(ElementaVersion elementaVersion, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 244;
        }
        this(elementaVersion, n);
    }

    public final int getAnimationFPS() {
        return this.animationFPS;
    }

    @Nullable
    public final UIComponent getHoveredFloatingComponent() {
        return this.hoveredFloatingComponent;
    }

    public final void setHoveredFloatingComponent(@Nullable UIComponent uIComponent) {
        this.hoveredFloatingComponent = uIComponent;
    }

    @Nullable
    public final UIComponent getFocusedComponent() {
        return this.focusedComponent;
    }

    @Nullable
    public final Function3<Double, Double, Integer, Boolean> getClickInterceptor$Elementa() {
        return this.clickInterceptor;
    }

    public final void setClickInterceptor$Elementa(@Nullable Function3<? super Double, ? super Double, ? super Integer, Boolean> function3) {
        this.clickInterceptor = function3;
    }

    @Deprecated(message="Add ElementaVersion as the first argument to opt-in to improved behavior.")
    @JvmOverloads
    public Window(int animationFPS) {
        this(ElementaVersion.Companion.getV0$Elementa(), animationFPS);
    }

    public /* synthetic */ Window(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 244;
        }
        this(n);
    }

    @Override
    public void afterInitialization() {
        Companion.enqueueRenderOperation(afterInitialization.1.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        ElementaVersion this_$iv = this.version;
        boolean $i$f$enableFor = false;
        ElementaVersion prevVersion$iv = ElementaVersion.Companion.getActive();
        ElementaVersion.Companion.setActive(this_$iv);
        try {
            boolean bl = false;
            this.doDraw(matrixStack);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            ElementaVersion.Companion.setActive(prevVersion$iv);
        }
    }

    private final void doDraw(UMatrixStack matrixStack) {
        if (this.cancelDrawing) {
            return;
        }
        InvalidUsageKt.requireMainThread$default(null, 1, null);
        long startTime = System.nanoTime();
        Object object = renderOperations.iterator();
        Intrinsics.checkNotNullExpressionValue(object, "renderOperations.iterator()");
        Iterator<Function0<Unit>> it = object;
        while (it.hasNext() && System.nanoTime() - startTime < TimeUnit.MILLISECONDS.toNanos(5L)) {
            it.next().invoke();
            it.remove();
        }
        if (this.systemTime == -1L) {
            this.systemTime = System.currentTimeMillis();
        }
        try {
            if (System.currentTimeMillis() - this.systemTime > TimeUnit.SECONDS.toMillis(5L)) {
                this.systemTime = System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(5L);
            }
            while (this.systemTime < System.currentTimeMillis() + (long)(1000 / this.animationFPS)) {
                this.animationFrame();
                this.systemTime += (long)(1000 / this.animationFPS);
            }
            this.hoveredFloatingComponent = null;
            object = this.getMousePosition();
            float mouseX = ((Number)((Pair)object).component1()).floatValue();
            float mouseY = ((Number)((Pair)object).component2()).floatValue();
            for (UIComponent component2 : CollectionsKt.reversed((Iterable)this.floatingComponents)) {
                if (!component2.isPointInside(mouseX, mouseY)) continue;
                this.hoveredFloatingComponent = component2;
                break;
            }
            this.mouseMove(this);
            this.beforeDraw(matrixStack);
            super.draw(matrixStack);
        }
        catch (Throwable e) {
            ConstraintResolutionGui constraintResolutionGui;
            String guiName;
            String string;
            this.cancelDrawing = true;
            Object object2 = Platform.Companion.getPlatform$Elementa().getCurrentScreen();
            if (object2 == null) {
                string = "<unknown>";
            } else {
                Class<?> clazz = object2.getClass();
                if (clazz == null) {
                    string = "<unknown>";
                } else {
                    string = clazz.getSimpleName();
                    if (string == null) {
                        string = guiName = "<unknown>";
                    }
                }
            }
            if (e instanceof StackOverflowError) {
                System.out.println((Object)"Elementa: Cyclic constraint structure detected!");
                System.out.println((Object)"If you are a developer, set the environment variable \"elementa.dev=true\" to assist in debugging the issue.");
            } else {
                System.out.println((Object)"Elementa: encountered an error while drawing a GUI");
            }
            System.out.println((Object)Intrinsics.stringPlus("Gui name: ", guiName));
            e.printStackTrace();
            ScissorEffect.Companion.setCurrentScissorState(null);
            GL11.glDisable((int)3089);
            Platform platform = Platform.Companion.getPlatform$Elementa();
            if (e instanceof StackOverflowError && OptionsKt.getElementaDev()) {
                List<ResolverNode> list;
                String string2 = System.getProperty("elementa.dev.cycle_resolver", "2");
                if (Intrinsics.areEqual(string2, "2")) {
                    list = new ConstraintResolverV2(this).getCyclicNodes();
                } else if (Intrinsics.areEqual(string2, "1")) {
                    list = new ConstraintResolver(this).getCyclicNodes();
                } else {
                    System.out.println((Object)"Invalid value for \"elementa.dev.cycle_resolver\", falling back to V2 solver.");
                    list = new ConstraintResolverV2(this).getCyclicNodes();
                }
                List<ResolverNode> cyclicNodes = list;
                constraintResolutionGui = new ConstraintResolutionGui(guiName, this, cyclicNodes);
            } else {
                UChat.chat("\u00a7cElementa encountered an error while drawing a GUI. Check your logs for more information.");
                constraintResolutionGui = null;
            }
            platform.setCurrentScreen((Object)constraintResolutionGui);
        }
    }

    public final void drawEmbedded$Elementa(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        super.draw(matrixStack);
    }

    @Deprecated(message="For 1.17 this method requires you pass a UMatrixStack as the first argument.\n\nIf you are currently extending this method, you should instead extend the method with the added argument.\nNote however for this to be non-breaking, your parent class needs to transition before you do.\n\nIf you are calling this method and you cannot guarantee that your target class has been fully updated (such as when\ncalling an open method on an open class), you should instead call the method with the \"Compat\" suffix, which will\ncall both methods, the new and the deprecated one.\nIf you are sure that your target class has been updated (such as when calling the super method), you should\n(for super calls you must!) instead just call the method with the original name and added argument.", replaceWith=@ReplaceWith(expression="drawFloatingComponents(matrixStack)", imports={}))
    public final void drawFloatingComponents() {
        this.drawFloatingComponents(new UMatrixStack());
    }

    public final void drawFloatingComponents(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        InvalidUsageKt.requireMainThread$default(null, 1, null);
        Iterator<UIComponent> it = this.floatingComponents.iterator();
        while (it.hasNext()) {
            UIComponent component2 = it.next();
            if (Companion.ofOrNull(component2) == null) {
                it.remove();
                continue;
            }
            component2.drawCompat(matrixStack);
        }
    }

    @Override
    public void mouseScroll(double delta) {
        InvalidUsageKt.requireMainThread$default(null, 1, null);
        Pair<Float, Float> pair = this.getMousePosition();
        float mouseX = ((Number)pair.component1()).floatValue();
        float mouseY = ((Number)pair.component2()).floatValue();
        for (UIComponent floatingComponent : CollectionsKt.reversed((Iterable)this.floatingComponents)) {
            if (!floatingComponent.isPointInside(mouseX, mouseY)) continue;
            floatingComponent.mouseScroll(delta);
            return;
        }
        super.mouseScroll(delta);
    }

    @Override
    public void mouseClick(double mouseX, double mouseY, int button2) {
        InvalidUsageKt.requireMainThread$default(null, 1, null);
        this.currentMouseButton = button2;
        Function3<? super Double, ? super Double, ? super Integer, Boolean> function3 = this.clickInterceptor;
        if (function3 != null) {
            Function3<? super Double, ? super Double, ? super Integer, Boolean> it = function3;
            boolean bl = false;
            if (it.invoke((Double)mouseX, (Double)mouseY, (Integer)button2).booleanValue()) {
                return;
            }
        }
        for (UIComponent floatingComponent : CollectionsKt.reversed((Iterable)this.floatingComponents)) {
            if (!floatingComponent.isPointInside((float)mouseX, (float)mouseY)) continue;
            floatingComponent.mouseClick(mouseX, mouseY, button2);
            this.dealWithFocusRequests();
            return;
        }
        super.mouseClick(mouseX, mouseY, button2);
        this.dealWithFocusRequests();
    }

    private final void dealWithFocusRequests() {
        if (this.componentRequestingFocus == null) {
            this.unfocus();
        } else if (!Intrinsics.areEqual(this.componentRequestingFocus, this.focusedComponent)) {
            if (this.focusedComponent != null) {
                UIComponent uIComponent = this.focusedComponent;
                if (uIComponent != null) {
                    uIComponent.loseFocus();
                }
            }
            UIComponent uIComponent = this.focusedComponent = this.componentRequestingFocus;
            if (uIComponent != null) {
                uIComponent.focus();
            }
        }
        this.componentRequestingFocus = null;
    }

    @Override
    public void mouseRelease() {
        InvalidUsageKt.requireMainThread$default(null, 1, null);
        super.mouseRelease();
        this.currentMouseButton = -1;
    }

    @Override
    public void keyType(char typedChar, int keyCode) {
        InvalidUsageKt.requireMainThread$default(null, 1, null);
        if (this.focusedComponent != null) {
            UIComponent uIComponent = this.focusedComponent;
            if (uIComponent != null) {
                uIComponent.keyType(typedChar, keyCode);
            }
        } else {
            super.keyType(typedChar, keyCode);
        }
    }

    @Override
    public void animationFrame() {
        if (this.currentMouseButton != -1) {
            Pair<Float, Float> pair = this.getMousePosition();
            float mouseX = ((Number)pair.component1()).floatValue();
            float mouseY = ((Number)pair.component2()).floatValue();
            this.dragMouse((int)mouseX, (int)mouseY, this.currentMouseButton);
        }
        if (this.componentRequestingFocus != null && !Intrinsics.areEqual(this.componentRequestingFocus, this.focusedComponent)) {
            if (this.focusedComponent != null) {
                UIComponent uIComponent = this.focusedComponent;
                if (uIComponent != null) {
                    uIComponent.loseFocus();
                }
            }
            UIComponent uIComponent = this.focusedComponent = this.componentRequestingFocus;
            if (uIComponent != null) {
                uIComponent.focus();
            }
        }
        this.componentRequestingFocus = null;
        super.animationFrame();
    }

    @Override
    public float getLeft() {
        return 0.0f;
    }

    @Override
    public float getTop() {
        return 0.0f;
    }

    @Override
    public float getWidth() {
        return UResolution.getScaledWidth();
    }

    @Override
    public float getHeight() {
        return UResolution.getScaledHeight();
    }

    @Override
    public float getRight() {
        return this.getWidth();
    }

    @Override
    public float getBottom() {
        return this.getHeight();
    }

    public final boolean isAreaVisible(double left2, double top, double right, double bottom) {
        if (right < (double)this.getLeft() || left2 > (double)this.getRight() || bottom < (double)this.getTop() || top > (double)this.getBottom()) {
            return false;
        }
        ScissorEffect.ScissorState scissorState = ScissorEffect.Companion.getCurrentScissorState();
        if (scissorState == null) {
            return true;
        }
        ScissorEffect.ScissorState currentScissor = scissorState;
        double sf = UResolution.getScaleFactor();
        double realX = (double)currentScissor.getX() / sf;
        double realWidth = (double)currentScissor.getWidth() / sf;
        double bottomY = ((double)UResolution.getScaledHeight() * sf - (double)currentScissor.getY()) / sf;
        double realHeight = (double)currentScissor.getHeight() / sf;
        return right > realX && left2 < realX + realWidth && bottom >= bottomY - realHeight && top <= bottomY;
    }

    public final void addFloatingComponent(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter(component2, "component");
        if (this.isInitialized()) {
            InvalidUsageKt.requireMainThread$default(null, 1, null);
        }
        if (this.floatingComponents.contains(component2)) {
            return;
        }
        this.floatingComponents.add(component2);
    }

    public final void removeFloatingComponent(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter(component2, "component");
        if (this.isInitialized()) {
            InvalidUsageKt.requireMainThread$default(null, 1, null);
        }
        this.floatingComponents.remove(component2);
    }

    public final void focus(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter(component2, "component");
        if (this.isInitialized()) {
            InvalidUsageKt.requireMainThread$default(null, 1, null);
        }
        this.componentRequestingFocus = component2;
    }

    public final void unfocus() {
        if (this.isInitialized()) {
            InvalidUsageKt.requireMainThread$default(null, 1, null);
        }
        UIComponent uIComponent = this.focusedComponent;
        if (uIComponent != null) {
            uIComponent.loseFocus();
        }
        this.focusedComponent = null;
    }

    @JvmOverloads
    public Window(@NotNull ElementaVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, "version");
        this(version, 0, 2, null);
    }

    @Deprecated(message="Add ElementaVersion as the first argument to opt-in to improved behavior.")
    @JvmOverloads
    public Window() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u0005\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\bJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000e\u0010\rR \u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lgg/essential/elementa/components/Window$Companion;", "", "Lkotlin/Function0;", "", "operation", "enqueueRenderOperation", "(Lkotlin/jvm/functions/Function0;)V", "Ljava/lang/Runnable;", "(Ljava/lang/Runnable;)V", "Lgg/essential/elementa/UIComponent;", "component", "Lgg/essential/elementa/components/Window;", "of", "(Lgg/essential/elementa/UIComponent;)Lgg/essential/elementa/components/Window;", "ofOrNull", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "renderOperations", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "<init>", "()V", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        public final void enqueueRenderOperation(@NotNull Runnable operation) {
            Intrinsics.checkNotNullParameter(operation, "operation");
            renderOperations.add(new Function0<Unit>(operation){
                final /* synthetic */ Runnable $operation;
                {
                    this.$operation = $operation;
                    super(0);
                }

                public final void invoke() {
                    this.$operation.run();
                }
            });
        }

        public final void enqueueRenderOperation(@NotNull Function0<Unit> operation) {
            Intrinsics.checkNotNullParameter(operation, "operation");
            renderOperations.add(operation);
        }

        @NotNull
        public final Window of(@NotNull UIComponent component2) {
            Intrinsics.checkNotNullParameter(component2, "component");
            Window window = this.ofOrNull(component2);
            if (window == null) {
                throw new IllegalStateException("No window parent? It's possible you haven't called Window.addChild() at this point in time.");
            }
            return window;
        }

        @Nullable
        public final Window ofOrNull(@NotNull UIComponent component2) {
            Window window;
            Intrinsics.checkNotNullParameter(component2, "component");
            Window window2 = component2.getCachedWindow$Elementa();
            if (window2 == null) {
                Companion $this$ofOrNull_u24lambda_u2d0 = this;
                boolean bl = false;
                UIComponent current = component2;
                while (!(current instanceof Window) && current.getHasParent() && !Intrinsics.areEqual(current.getParent(), current)) {
                    current = current.getParent();
                }
                UIComponent uIComponent = current;
                window = uIComponent instanceof Window ? (Window)uIComponent : null;
            } else {
                window = window2;
            }
            return window;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

