/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.components;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.components.image.ImageProvider;
import gg.essential.elementa.impl.Platform;
import gg.essential.elementa.svg.SVGParser;
import gg.essential.elementa.svg.data.SVG;
import gg.essential.elementa.svg.data.SVGElement;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0001'B\u000f\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b&\u0010\u0017J\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J?\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u0015\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001c\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010\u0015\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u001eR\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0016\u0010$\u001a\u00020#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%\u00a8\u0006("}, d2={"Lgg/essential/elementa/components/SVGComponent;", "Lgg/essential/elementa/UIComponent;", "Lgg/essential/elementa/components/image/ImageProvider;", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "", "draw", "(Lgg/essential/universal/UMatrixStack;)V", "", "x", "y", "width", "height", "Ljava/awt/Color;", "color", "drawImage", "(Lgg/essential/universal/UMatrixStack;DDDDLjava/awt/Color;)V", "finalize", "()V", "generateVBOData", "Lgg/essential/elementa/svg/data/SVG;", "svg", "setSVG", "(Lgg/essential/elementa/svg/data/SVG;)V", "Lkotlin/Function0;", "finalizeRunnable", "Lkotlin/jvm/functions/Function0;", "", "needsReload", "Z", "Lgg/essential/elementa/svg/data/SVG;", "", "Lgg/essential/elementa/components/SVGComponent$Companion$VBOData;", "vboData", "Ljava/util/List;", "", "vboID", "I", "<init>", "Companion", "Elementa"})
public final class SVGComponent
extends UIComponent
implements ImageProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private SVG svg;
    private int vboID;
    private List<Companion.VBOData> vboData;
    private boolean needsReload;
    @NotNull
    private final Function0<Unit> finalizeRunnable;

    public SVGComponent(@NotNull SVG svg) {
        Intrinsics.checkNotNullParameter(svg, "svg");
        this.svg = svg;
        this.vboID = -1;
        this.finalizeRunnable = new Function0<Unit>(this){
            final /* synthetic */ SVGComponent this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                GL15.glDeleteBuffers((int)SVGComponent.access$getVboID$p(this.this$0));
            }
        };
    }

    public final void setSVG(@NotNull SVG svg) {
        Intrinsics.checkNotNullParameter(svg, "svg");
        this.svg = svg;
        this.needsReload = true;
    }

    @Override
    public void drawImage(@NotNull UMatrixStack matrixStack, double x, double y, double width, double height, @NotNull Color color) {
        double d;
        double d2;
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        Intrinsics.checkNotNullParameter(color, "color");
        if (Platform.Companion.getPlatform$Elementa().getMcVersion() >= 11700) {
            return;
        }
        if (this.vboData == null || this.needsReload) {
            this.generateVBOData();
            this.needsReload = false;
        }
        Float f = this.svg.getWidth();
        if (f == null) {
            d2 = 1.0;
        } else {
            double d3;
            float it = ((Number)f).floatValue();
            boolean bl = false;
            d2 = d3 = width / (double)it;
        }
        double xScale = d2;
        Float f2 = this.svg.getHeight();
        if (f2 == null) {
            d = 1.0;
        } else {
            double d4;
            float it = ((Number)f2).floatValue();
            boolean bl = false;
            d = d4 = height / (double)it;
        }
        double yScale = d;
        float strokeWidth = RangesKt.coerceAtMost((float)(xScale * (double)this.svg.getStrokeWidth()), 10.0f);
        matrixStack.push();
        UGraphics.enableBlend();
        UGraphics.disableTexture2D();
        GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
        matrixStack.translate(x, y, 0.0);
        matrixStack.scale(xScale, yScale, 0.0);
        GL11.glPointSize((float)strokeWidth);
        GL11.glLineWidth((float)strokeWidth);
        GL11.glEnable((int)2848);
        GL11.glEnable((int)2832);
        GL15.glBindBuffer((int)34962, (int)this.vboID);
        GL11.glEnableClientState((int)32884);
        GL11.glVertexPointer((int)2, (int)5126, (int)0, (long)0L);
        matrixStack.runWithGlobalState((Function0)new Function0<Unit>(this){
            final /* synthetic */ SVGComponent this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                List list = SVGComponent.access$getVboData$p(this.this$0);
                if (list == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("vboData");
                    list = null;
                }
                Iterable iterable = list;
                SVGComponent sVGComponent = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Companion.VBOData $dstr$drawType$startIndex$vertexCount$drawPoints = (Companion.VBOData)element$iv;
                    boolean bl = false;
                    int drawType = $dstr$drawType$startIndex$vertexCount$drawPoints.component1();
                    int startIndex = $dstr$drawType$startIndex$vertexCount$drawPoints.component2();
                    int vertexCount = $dstr$drawType$startIndex$vertexCount$drawPoints.component3();
                    boolean drawPoints = $dstr$drawType$startIndex$vertexCount$drawPoints.component4();
                    GL11.glDrawArrays((int)drawType, (int)startIndex, (int)vertexCount);
                    if (!drawPoints || !SVGComponent.access$getSvg$p(sVGComponent).getRoundLineJoins()) continue;
                    GL11.glDrawArrays((int)0, (int)startIndex, (int)vertexCount);
                }
            }
        });
        GL11.glDisable((int)2848);
        GL11.glDisable((int)2832);
        GL11.glDisableClientState((int)32884);
        GL15.glBindBuffer((int)34962, (int)0);
        UGraphics.enableTexture2D();
        matrixStack.pop();
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        this.beforeDraw(matrixStack);
        double x = this.getLeft();
        double y = this.getTop();
        double width = this.getWidth();
        double height = this.getHeight();
        Color color = this.getColor();
        if (color.getAlpha() == 0) {
            super.draw(matrixStack);
            return;
        }
        this.drawImage(matrixStack, x, y, width, height, color);
        super.draw(matrixStack);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateVBOData() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void it;
        this.vboID = GL15.glGenBuffers();
        Iterable iterable = this.svg.getElements();
        int n = 0;
        for (Object t : iterable) {
            SVGElement sVGElement = (SVGElement)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getVertexCount();
            n = n2 + n3;
        }
        int totalVertexCount = n;
        FloatBuffer vertexBuffer = BufferUtils.createFloatBuffer((int)(totalVertexCount * 2));
        int currPos = 0;
        Iterable iterable2 = this.svg.getElements();
        SVGComponent sVGComponent = this;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Companion.VBOData vBOData;
            void el;
            SVGElement sVGElement = (SVGElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int vertexCount = el.getVertexCount();
            Intrinsics.checkNotNullExpressionValue(vertexBuffer, "vertexBuffer");
            Companion.VBOData it2 = vBOData = new Companion.VBOData(el.createBuffer(vertexBuffer), currPos, vertexCount, el.drawSmoothPoints());
            boolean bl2 = false;
            currPos += vertexCount;
            collection.add(vBOData);
        }
        sVGComponent.vboData = (List)destination$iv$iv;
        vertexBuffer.rewind();
        GL15.glBindBuffer((int)34962, (int)this.vboID);
        GL15.glBufferData((int)34962, (FloatBuffer)vertexBuffer, (int)35044);
        GL15.glBindBuffer((int)34962, (int)0);
    }

    public final void finalize() {
        Window.Companion.enqueueRenderOperation(this.finalizeRunnable);
    }

    public static final /* synthetic */ List access$getVboData$p(SVGComponent $this) {
        return $this.vboData;
    }

    public static final /* synthetic */ SVG access$getSvg$p(SVGComponent $this) {
        return $this.svg;
    }

    public static final /* synthetic */ int access$getVboID$p(SVGComponent $this) {
        return $this.vboID;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\tB\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lgg/essential/elementa/components/SVGComponent$Companion;", "", "", "resourcePath", "Lgg/essential/elementa/components/SVGComponent;", "ofResource", "(Ljava/lang/String;)Lgg/essential/elementa/components/SVGComponent;", "<init>", "()V", "VBOData", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SVGComponent ofResource(@NotNull String resourcePath) {
            Intrinsics.checkNotNullParameter(resourcePath, "resourcePath");
            return new SVGComponent(SVGParser.INSTANCE.parseFromResource(resourcePath));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\n\u001a\u00020\u0002\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u0012\u0006\u0010\f\u001a\u00020\u0002\u0012\u0006\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u0010\u0010\b\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ8\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\n\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u00022\b\b\u0002\u0010\r\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0011\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0017\u0010\f\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\u0017\u001a\u0004\b\u0018\u0010\u0004R\u0017\u0010\r\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u0019\u001a\u0004\b\u001a\u0010\tR\u0017\u0010\n\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0017\u001a\u0004\b\u001b\u0010\u0004R\u0017\u0010\u000b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0017\u001a\u0004\b\u001c\u0010\u0004\u00a8\u0006\u001f"}, d2={"Lgg/essential/elementa/components/SVGComponent$Companion$VBOData;", "", "", "component1", "()I", "component2", "component3", "", "component4", "()Z", "drawType", "startIndex", "count", "drawPoints", "copy", "(IIIZ)Lgg/essential/elementa/components/SVGComponent$Companion$VBOData;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getCount", "Z", "getDrawPoints", "getDrawType", "getStartIndex", "<init>", "(IIIZ)V", "Elementa"})
        private static final class VBOData {
            private final int drawType;
            private final int startIndex;
            private final int count;
            private final boolean drawPoints;

            public VBOData(int drawType, int startIndex, int count2, boolean drawPoints) {
                this.drawType = drawType;
                this.startIndex = startIndex;
                this.count = count2;
                this.drawPoints = drawPoints;
            }

            public final int getDrawType() {
                return this.drawType;
            }

            public final int getStartIndex() {
                return this.startIndex;
            }

            public final int getCount() {
                return this.count;
            }

            public final boolean getDrawPoints() {
                return this.drawPoints;
            }

            public final int component1() {
                return this.drawType;
            }

            public final int component2() {
                return this.startIndex;
            }

            public final int component3() {
                return this.count;
            }

            public final boolean component4() {
                return this.drawPoints;
            }

            @NotNull
            public final VBOData copy(int drawType, int startIndex, int count2, boolean drawPoints) {
                return new VBOData(drawType, startIndex, count2, drawPoints);
            }

            public static /* synthetic */ VBOData copy$default(VBOData vBOData, int n, int n2, int n3, boolean bl, int n4, Object object) {
                if ((n4 & 1) != 0) {
                    n = vBOData.drawType;
                }
                if ((n4 & 2) != 0) {
                    n2 = vBOData.startIndex;
                }
                if ((n4 & 4) != 0) {
                    n3 = vBOData.count;
                }
                if ((n4 & 8) != 0) {
                    bl = vBOData.drawPoints;
                }
                return vBOData.copy(n, n2, n3, bl);
            }

            @NotNull
            public String toString() {
                return "VBOData(drawType=" + this.drawType + ", startIndex=" + this.startIndex + ", count=" + this.count + ", drawPoints=" + this.drawPoints + ')';
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.drawType);
                result2 = result2 * 31 + Integer.hashCode(this.startIndex);
                result2 = result2 * 31 + Integer.hashCode(this.count);
                int n = this.drawPoints ? 1 : 0;
                if (n != 0) {
                    n = 1;
                }
                result2 = result2 * 31 + n;
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof VBOData)) {
                    return false;
                }
                VBOData vBOData = (VBOData)other;
                if (this.drawType != vBOData.drawType) {
                    return false;
                }
                if (this.startIndex != vBOData.startIndex) {
                    return false;
                }
                if (this.count != vBOData.count) {
                    return false;
                }
                return this.drawPoints == vBOData.drawPoints;
            }
        }
    }
}

