/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.data;

import com.google.gson.annotations.SerializedName;
import gg.essential.Essential;
import gg.essential.event.essential.TosAcceptedEvent;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0016\u0010\u000bJ\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u000f\u0010\u0007\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0007\u0010\u0004J\u000f\u0010\b\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\b\u0010\u0004J\u000f\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\u000bJ\u000f\u0010\r\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\r\u0010\u000bJ\u000f\u0010\u000e\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000bJ\u000f\u0010\u000f\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u000bR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0014\u001a\u00020\u00138\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lgg/essential/data/OnboardingData;", "Lgg/essential/api/data/OnboardingData;", "", "hasAcceptedEssentialTOS", "()Z", "hasAcceptedTos", "hasDeniedEssentialTOS", "hasDeniedTos", "hasSeenFriendsOption", "", "loadData", "()V", "saveData", "setAcceptedTos", "setDeniedTos", "setSeenFriendsOption", "Ljava/io/File;", "onboardingFile", "Ljava/io/File;", "Lgg/essential/data/OnboardingData$State;", "state", "Lgg/essential/data/OnboardingData$State;", "<init>", "State", "Essential 1.19-fabric"})
public final class OnboardingData
implements gg.essential.api.data.OnboardingData {
    @NotNull
    public static final OnboardingData INSTANCE = new OnboardingData();
    @NotNull
    private static final File onboardingFile = new File(Essential.getInstance().getBaseDir(), "onboarding.json");
    private static State state;

    private OnboardingData() {
    }

    @JvmStatic
    public static final boolean hasAcceptedTos() {
        INSTANCE.loadData();
        State state = OnboardingData.state;
        if (state == null) {
            Intrinsics.throwUninitializedPropertyAccessException("state");
            state = null;
        }
        return Intrinsics.areEqual(state.getAcceptedTos(), true);
    }

    @JvmStatic
    public static final boolean hasDeniedTos() {
        INSTANCE.loadData();
        State state = OnboardingData.state;
        if (state == null) {
            Intrinsics.throwUninitializedPropertyAccessException("state");
            state = null;
        }
        return Intrinsics.areEqual(state.getAcceptedTos(), false);
    }

    @JvmStatic
    public static final void setAcceptedTos() {
        INSTANCE.loadData();
        State state = OnboardingData.state;
        if (state == null) {
            Intrinsics.throwUninitializedPropertyAccessException("state");
            state = null;
        }
        if (!Intrinsics.areEqual(state.getAcceptedTos(), true)) {
            State state2 = OnboardingData.state;
            if (state2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("state");
                state2 = null;
            }
            state2.setAcceptedTos(true);
            Essential.EVENT_BUS.post(new TosAcceptedEvent());
            INSTANCE.saveData();
        }
    }

    @JvmStatic
    public static final void setDeniedTos() {
        INSTANCE.loadData();
        State state = OnboardingData.state;
        if (state == null) {
            Intrinsics.throwUninitializedPropertyAccessException("state");
            state = null;
        }
        if (!Intrinsics.areEqual(state.getAcceptedTos(), false)) {
            State state2 = OnboardingData.state;
            if (state2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("state");
                state2 = null;
            }
            state2.setAcceptedTos(false);
            INSTANCE.saveData();
        }
    }

    @JvmStatic
    public static final boolean hasSeenFriendsOption() {
        INSTANCE.loadData();
        State state = OnboardingData.state;
        if (state == null) {
            Intrinsics.throwUninitializedPropertyAccessException("state");
            state = null;
        }
        return state.getSeenFriendsOption();
    }

    @JvmStatic
    public static final void setSeenFriendsOption() {
        INSTANCE.loadData();
        State state = OnboardingData.state;
        if (state == null) {
            Intrinsics.throwUninitializedPropertyAccessException("state");
            state = null;
        }
        if (!state.getSeenFriendsOption()) {
            State state2 = OnboardingData.state;
            if (state2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("state");
                state2 = null;
            }
            state2.setSeenFriendsOption(true);
            INSTANCE.saveData();
        }
    }

    @Override
    public boolean hasAcceptedEssentialTOS() {
        return OnboardingData.hasAcceptedTos();
    }

    @Override
    public boolean hasDeniedEssentialTOS() {
        return OnboardingData.hasDeniedTos();
    }

    private final void loadData() {
        if (state != null) {
            return;
        }
        if (!onboardingFile.exists()) {
            state = new State();
            this.saveData();
        } else {
            try {
                Object object = Essential.GSON.fromJson(FilesKt.readText$default(onboardingFile, null, 1, null), State.class);
                Intrinsics.checkNotNullExpressionValue(object, "GSON.fromJson(onboarding\u2026ext(), State::class.java)");
                state = (State)object;
            }
            catch (Exception e) {
                Essential.logger.error("Failed to read from Onboarding JSON, rewriting file.");
                state = new State();
                this.saveData();
            }
        }
    }

    private final void saveData() {
        if (state != null) {
            State state = OnboardingData.state;
            if (state == null) {
                Intrinsics.throwUninitializedPropertyAccessException("state");
                state = null;
            }
            String string = Essential.GSON.toJson((Object)state);
            Intrinsics.checkNotNullExpressionValue(string, "GSON.toJson(state)");
            FilesKt.writeText$default(onboardingFile, string, null, 2, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010R$\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lgg/essential/data/OnboardingData$State;", "", "", "acceptedTos", "Ljava/lang/Boolean;", "getAcceptedTos", "()Ljava/lang/Boolean;", "setAcceptedTos", "(Ljava/lang/Boolean;)V", "seenFriendsOption", "Z", "getSeenFriendsOption", "()Z", "setSeenFriendsOption", "(Z)V", "<init>", "()V", "Essential 1.19-fabric"})
    private static final class State {
        @SerializedName(value="accepted_tos")
        @Nullable
        private Boolean acceptedTos;
        @SerializedName(value="seen_share_server_with_friends_option")
        private boolean seenFriendsOption;

        @Nullable
        public final Boolean getAcceptedTos() {
            return this.acceptedTos;
        }

        public final void setAcceptedTos(@Nullable Boolean bl) {
            this.acceptedTos = bl;
        }

        public final boolean getSeenFriendsOption() {
            return this.seenFriendsOption;
        }

        public final void setSeenFriendsOption(boolean bl) {
            this.seenFriendsOption = bl;
        }
    }
}

