/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics.skinmask;

import gg.essential.Essential;
import gg.essential.cosmetics.PlayerModelRenderState;
import gg.essential.cosmetics.model.Cosmetic;
import gg.essential.cosmetics.model.CosmeticSetting;
import gg.essential.cosmetics.model.CosmeticSkinMask;
import gg.essential.cosmetics.skinmask.MaskedSkinProvider;
import gg.essential.cosmetics.skinmask.ModelMaskInstance;
import gg.essential.cosmetics.skinmask.SkinPartSetting;
import gg.essential.cosmetics.skinmask.SkinRegion;
import gg.essential.model.EnumPart;
import gg.essential.model.EssentialAsset;
import gg.essential.model.Vector3;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsManager;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.Multithreading;
import gg.essential.util.UImage;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.imageio.ImageIO;
import kotlin.Pair;

public class SkinMasker {
    private static final Map<EnumPart, Pair<Vector3, Vector3>> skinArea = new EnumMap<EnumPart, Pair<Vector3, Vector3>>(EnumPart.class);
    private static final Map<EnumPart, List<SkinRegion>> skinRegions = new EnumMap<EnumPart, List<SkinRegion>>(EnumPart.class);
    private static final Pair<Integer, Integer> cachedOutOfBounds = new Pair<Integer, Integer>(-1, -1);

    public static CompletableFuture<UImage> generateMaskedSkin(UImage skin, String skinType, MaskedSkinProvider.Config config, PlayerModelRenderState state) {
        Map<String, List<EnumPart>> hiddenPartsMap = state.getHiddenParts(config.cosmetics.values(), config.armour);
        CosmeticsManager cosmeticsManager = Essential.getInstance().getConnectionManager().getCosmeticsManager();
        ArrayList<CompletionStage> maskFutures = new ArrayList<CompletionStage>();
        for (Cosmetic cosmetic : config.cosmetics.keySet()) {
            CosmeticSkinMask skinMasks = cosmetic.getAssets().getSkinMask();
            if (skinMasks == null) continue;
            EssentialAsset steveSkinMask = skinMasks.getSteve();
            EssentialAsset alexSkinMask = skinMasks.getAlex();
            ArrayList<SkinPartSetting> cosmeticSettings = new ArrayList<SkinPartSetting>();
            List<EnumPart> hiddenParts = hiddenPartsMap.get(cosmetic.getId());
            if (hiddenParts != null && !hiddenParts.isEmpty()) {
                for (EnumPart hiddenPart : hiddenParts) {
                    cosmeticSettings.add(new SkinPartSetting(hiddenPart, true, 0, 0, 0));
                }
            }
            for (CosmeticSetting setting : config.settings) {
                if (!cosmetic.getId().equals(setting.getId()) || !setting.getType().equals("PLAYER_POSITION_ADJUSTMENT")) continue;
                for (EnumPart value2 : EnumPart.values()) {
                    cosmeticSettings.add(new SkinPartSetting(value2, false, setting.hasData("x") ? ((Number)setting.getData("x")).intValue() : 0, setting.hasData("y") ? ((Number)setting.getData("y")).intValue() : 0, setting.hasData("z") ? ((Number)setting.getData("z")).intValue() : 0));
                }
            }
            SkinPartSetting[] settings = cosmeticSettings.toArray(new SkinPartSetting[0]);
            CompletableFuture<byte[]> assetBytes = null;
            if (steveSkinMask != null && ("default".equals(skinType) || alexSkinMask == null)) {
                assetBytes = cosmeticsManager.getAssetBytes(steveSkinMask);
            }
            if (alexSkinMask != null && "slim".equalsIgnoreCase(skinType)) {
                assetBytes = cosmeticsManager.getAssetBytes(alexSkinMask);
            }
            if (assetBytes == null) continue;
            maskFutures.add(assetBytes.thenApply(it -> new ModelMaskInstance((byte[])it, settings)));
        }
        return ExtensionsKt.merge(maskFutures).thenApplyAsync(masks -> SkinMasker.applyMasks(skin, masks), (Executor)Multithreading.POOL);
    }

    private static UImage applyMasks(UImage image2, List<ModelMaskInstance> masks) {
        UImage newImage = UImage.ofSize(64, 64, false);
        newImage.copyFrom(image2);
        for (ModelMaskInstance maskInfo : masks) {
            BufferedImage mask;
            try {
                mask = ImageIO.read(new ByteArrayInputStream(maskInfo.data));
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            for (int x = 0; x < mask.getWidth(); ++x) {
                block4: for (int y = 0; y < mask.getHeight(); ++y) {
                    int rgb = mask.getRGB(x, y);
                    if ((rgb >> 16 & 0xFF) != 0 || (rgb >> 8 & 0xFF) != 0 || (rgb & 0xFF) != 0) continue;
                    for (SkinPartSetting skinPartSetting : maskInfo.settings) {
                        Pair<Integer, Integer> integerIntegerPair;
                        if (!SkinMasker.isPointInside(skinPartSetting.getPart(), x, y)) continue;
                        if (skinPartSetting.isHidden() || (integerIntegerPair = SkinMasker.applyPixelShift(skinPartSetting.getPart(), x, y, skinPartSetting.getShiftX(), skinPartSetting.getShiftY(), skinPartSetting.getShiftZ())).getFirst() == -1) continue block4;
                        newImage.set(integerIntegerPair.component1(), integerIntegerPair.component2(), 0);
                        continue block4;
                    }
                    newImage.set(x, y, 0);
                }
            }
        }
        return newImage;
    }

    private static Pair<Integer, Integer> applyPixelShift(EnumPart part, int x, int y, int shiftX, int shiftY, int shiftZ) {
        List<SkinRegion> skinRegions = SkinMasker.skinRegions.get((Object)part);
        if (skinRegions == null || skinRegions.isEmpty()) {
            return new Pair<Integer, Integer>(x, y);
        }
        block9: for (SkinRegion skinRegion : skinRegions) {
            int adjustX = x - skinRegion.getX();
            int adjustY = y - skinRegion.getY();
            Region region = SkinMasker.getRegion(skinRegion, adjustX, adjustY);
            switch (region) {
                case NONE: {
                    continue block9;
                }
                case FRONT: {
                    if (shiftZ == 0 && region == SkinMasker.getRegion(skinRegion, adjustX + shiftX, adjustY - shiftY)) {
                        return new Pair<Integer, Integer>(x + shiftX, y - shiftY);
                    }
                    return cachedOutOfBounds;
                }
                case BACK: {
                    if (shiftZ == 0 && region == SkinMasker.getRegion(skinRegion, adjustX - shiftX, adjustY - shiftY)) {
                        return new Pair<Integer, Integer>(x - shiftX, y - shiftY);
                    }
                    return cachedOutOfBounds;
                }
                case RIGHT: {
                    if (shiftX == 0 && region == SkinMasker.getRegion(skinRegion, adjustX - shiftZ, adjustY - shiftY)) {
                        return new Pair<Integer, Integer>(x - shiftZ, y - shiftY);
                    }
                    return cachedOutOfBounds;
                }
                case LEFT: {
                    if (shiftX == 0 && region == SkinMasker.getRegion(skinRegion, adjustX + shiftZ, adjustY - shiftY)) {
                        return new Pair<Integer, Integer>(x + shiftZ, y - shiftY);
                    }
                    return cachedOutOfBounds;
                }
                case TOP: {
                    if (shiftY == 0 && region == SkinMasker.getRegion(skinRegion, adjustX + shiftX, adjustY + shiftZ)) {
                        return new Pair<Integer, Integer>(x + shiftX, y + shiftZ);
                    }
                    return cachedOutOfBounds;
                }
                case BOTTOM: {
                    if (shiftY == 0 && region == SkinMasker.getRegion(skinRegion, adjustX - shiftZ, adjustY + shiftZ)) {
                        return new Pair<Integer, Integer>(x - shiftX, y + shiftZ);
                    }
                    return cachedOutOfBounds;
                }
            }
        }
        return new Pair<Integer, Integer>(x, y);
    }

    private static Region getRegion(SkinRegion region, int adjustX, int adjustY) {
        boolean secondColumn;
        int minorWidth = region.getMinorWidth();
        int majorWidth = region.getMajorWidth();
        int textureHeight = region.getTextureHeight();
        if (adjustX < 0 || adjustY < 0 || adjustX > 2 * majorWidth + 2 * minorWidth || adjustY > textureHeight + minorWidth) {
            return Region.NONE;
        }
        boolean thirdColumn = adjustX >= minorWidth + majorWidth && adjustX <= minorWidth * 2 + majorWidth;
        boolean bl = secondColumn = adjustX >= minorWidth && adjustX <= minorWidth + majorWidth;
        if (adjustY >= minorWidth) {
            if (adjustX < minorWidth) {
                return Region.RIGHT;
            }
            if (secondColumn) {
                return Region.FRONT;
            }
            if (thirdColumn) {
                return Region.LEFT;
            }
            if (adjustX > minorWidth + majorWidth * 2) {
                return Region.BACK;
            }
        } else {
            if (secondColumn) {
                return Region.TOP;
            }
            if (thirdColumn) {
                return Region.BOTTOM;
            }
        }
        return Region.NONE;
    }

    private static boolean isPointInside(EnumPart part, int x, int y) {
        Pair<Vector3, Vector3> box = skinArea.get((Object)part);
        if (box == null) {
            return false;
        }
        Vector3 min = box.component1();
        Vector3 max = box.component2();
        return (float)x >= min.x && (float)x <= max.x && (float)y >= min.y && (float)y <= max.y;
    }

    static {
        skinArea.put(EnumPart.HEAD, new Pair<Vector3, Vector3>(new Vector3(0.0f, 0.0f, 0.0f), new Vector3(64.0f, 16.0f, 0.0f)));
        skinArea.put(EnumPart.BODY, new Pair<Vector3, Vector3>(new Vector3(17.0f, 17.0f, 0.0f), new Vector3(41.0f, 49.0f, 0.0f)));
        skinArea.put(EnumPart.LEFT_ARM, new Pair<Vector3, Vector3>(new Vector3(33.0f, 50.0f, 0.0f), new Vector3(57.0f, 65.0f, 0.0f)));
        skinArea.put(EnumPart.RIGHT_ARM, new Pair<Vector3, Vector3>(new Vector3(41.0f, 17.0f, 0.0f), new Vector3(57.0f, 49.0f, 0.0f)));
        skinArea.put(EnumPart.LEFT_LEG, new Pair<Vector3, Vector3>(new Vector3(0.0f, 49.0f, 0.0f), new Vector3(32.0f, 64.0f, 0.0f)));
        skinArea.put(EnumPart.RIGHT_LEG, new Pair<Vector3, Vector3>(new Vector3(0.0f, 17.0f, 0.0f), new Vector3(16.0f, 48.0f, 0.0f)));
        skinRegions.put(EnumPart.HEAD, Arrays.asList(new SkinRegion(0, 0, 8, 8, 8), new SkinRegion(32, 0, 8, 8, 8)));
    }

    static enum Region {
        TOP,
        BOTTOM,
        RIGHT,
        FRONT,
        LEFT,
        BACK,
        NONE;

    }
}

