/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics.skinmask;

import gg.essential.api.utils.Multithreading;
import gg.essential.cosmetics.PlayerModelRenderState;
import gg.essential.cosmetics.WearableBedrockModel;
import gg.essential.cosmetics.model.Cosmetic;
import gg.essential.cosmetics.model.CosmeticSetting;
import gg.essential.cosmetics.skinmask.SkinMasker;
import gg.essential.lib.caffeine.cache.Cache;
import gg.essential.lib.caffeine.cache.Caffeine;
import gg.essential.lib.caffeine.cache.RemovalCause;
import gg.essential.lib.caffeine.cache.RemovalListener;
import gg.essential.lib.caffeine.cache.Scheduler;
import gg.essential.mixins.ext.client.renderer.PlayerSkinTextureExt;
import gg.essential.model.EnumPart;
import gg.essential.universal.UMinecraft;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.UImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1044;
import net.minecraft.class_1046;
import net.minecraft.class_1060;
import net.minecraft.class_1068;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaskedSkinProvider {
    private static final DynamicTextureManager dynamicTextureManager = new DynamicTextureManager();
    private class_2960 generatingSkin;
    private Config generatingConfig;
    private CompletableFuture<UImage> generatingSkinFuture;
    private class_2960 generatedSkin;
    private Config generatedConfig;
    private class_2960 generatedId;

    public class_2960 provide(class_2960 skin, String skinType, Config config, PlayerModelRenderState state) {
        UImage generatedTexture;
        if (config == null || !skin.method_12832().startsWith("skins/")) {
            this.generatedSkin = null;
            this.generatedConfig = null;
            return null;
        }
        class_1060 textureManager = class_310.method_1551().method_1531();
        if (skin.equals((Object)this.generatedSkin) && config.equals(this.generatedConfig) && this.generatedId != null) {
            dynamicTextureManager.keepAlive(this);
            return this.generatedId;
        }
        if (this.generatingSkinFuture == null || !skin.equals((Object)this.generatingSkin) || !config.equals(this.generatingConfig)) {
            class_1044 skinTexture = textureManager.method_4619(skin);
            if (skinTexture == null) {
                return null;
            }
            if (!(skinTexture instanceof PlayerSkinTextureExt)) {
                return null;
            }
            PlayerSkinTextureExt skinTextureExt = (PlayerSkinTextureExt)skinTexture;
            UImage skinImage = skinTextureExt.essential$getImage();
            if (skinImage == null) {
                return null;
            }
            this.generatingSkin = skin;
            this.generatingConfig = config;
            this.generatingSkinFuture = SkinMasker.generateMaskedSkin(skinImage, skinType, config, state);
        }
        if ((generatedTexture = (UImage)this.generatingSkinFuture.getNow(null)) == null) {
            return this.generatedSkin != null ? this.generatedId : null;
        }
        this.generatedSkin = skin;
        this.generatedConfig = config;
        this.generatingSkin = null;
        this.generatingConfig = null;
        this.generatingSkinFuture = null;
        this.generatedId = dynamicTextureManager.generateUniqueId(this.generatedSkin.toString().replace(':', '/'));
        dynamicTextureManager.register(this, this.generatedId, new MaskedSkinTexture(generatedTexture));
        return this.generatedId;
    }

    void expireTexture(class_2960 id2) {
        if (id2.equals((Object)this.generatedId)) {
            this.generatedId = null;
        }
        class_310.method_1551().method_1531().method_4615(id2);
    }

    public static class Config {
        public final Set<EnumPart> armour;
        public final Map<Cosmetic, WearableBedrockModel> cosmetics;
        public final Set<CosmeticSetting> settings;
        private final int hashCode;

        public Config(Map<Cosmetic, WearableBedrockModel> cosmetics, Set<CosmeticSetting> settings, Set<EnumPart> armour) {
            this.cosmetics = new HashMap<Cosmetic, WearableBedrockModel>(cosmetics);
            this.settings = new HashSet<CosmeticSetting>(settings);
            this.armour = armour;
            this.hashCode = Objects.hash(this.cosmetics, this.settings, armour);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Config config = (Config)o;
            if (this.hashCode != config.hashCode) {
                return false;
            }
            return Objects.equals(this.cosmetics, config.cosmetics) && Objects.equals(this.settings, config.settings) && Objects.equals(this.armour, config.armour);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class DynamicTextureManager
    implements RemovalListener<MaskedSkinProvider, class_2960> {
        private final Cache<MaskedSkinProvider, class_2960> loaded = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).executor(gg.essential.util.Multithreading.POOL).scheduler(Scheduler.forScheduledExecutorService(Multithreading.getScheduledPool())).removalListener(this).build();
        private int nextUniqueId;

        private DynamicTextureManager() {
        }

        public class_2960 generateUniqueId(String name) {
            return new class_2960("essential", String.format("masked_skins/%s/%d", name, this.nextUniqueId++));
        }

        public void register(MaskedSkinProvider provider2, class_2960 id2, MaskedSkinTexture texture) {
            class_310.method_1551().method_1531().method_4616(id2, (class_1044)texture);
            this.loaded.put(provider2, id2);
        }

        public void keepAlive(MaskedSkinProvider provider2) {
            this.loaded.getIfPresent(provider2);
        }

        @Override
        public void onRemoval(@Nullable MaskedSkinProvider provider2, @Nullable class_2960 id2, @NotNull RemovalCause cause) {
            if (id2 == null || provider2 == null) {
                return;
            }
            ExtensionsKt.getExecutor(UMinecraft.getMinecraft()).execute(() -> provider2.expireTexture(id2));
        }
    }

    private static class MaskedSkinTexture
    extends class_1046 {
        public MaskedSkinTexture(UImage image2) {
            super(null, "essential-masked-image", class_1068.method_4649(), false, null);
            ((PlayerSkinTextureExt)((Object)this)).essential$setImage(image2);
        }

        public void method_4625(@NotNull class_3300 resourceManager) {
        }
    }
}

