/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics.model;

import com.google.gson.annotations.SerializedName;
import com.sparkuniverse.toolbox.util.DateTime;
import gg.essential.cosmetics.SkinLayer;
import gg.essential.cosmetics.holder.PriceHolder;
import gg.essential.cosmetics.holder.SkinLayersHolder;
import gg.essential.cosmetics.model.CosmeticAssets;
import gg.essential.cosmetics.model.CosmeticSetting;
import gg.essential.holder.DisplayNameHolder;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Cosmetic
implements DisplayNameHolder,
PriceHolder,
SkinLayersHolder {
    @SerializedName(value="a")
    @NotNull
    private final String id;
    @SerializedName(value="b")
    @NotNull
    private final String type;
    @SerializedName(value="c")
    @NotNull
    private final Map<String, String> displayNames;
    @SerializedName(value="d")
    @NotNull
    private final CosmeticAssets assets;
    @SerializedName(value="e")
    @Nullable
    private final CosmeticSetting[] settings;
    @SerializedName(value="f")
    private final int storePackageId;
    @SerializedName(value="g")
    @NotNull
    private final Map<String, Double> prices;
    @SerializedName(value="h")
    private final @Nullable Set<@NotNull String> tags;
    @SerializedName(value="i")
    @NotNull
    private final DateTime createdAt;
    @SerializedName(value="j")
    @Nullable
    private final DateTime availableAfter;
    @SerializedName(value="k")
    @Nullable
    private final DateTime availableUntil;
    @SerializedName(value="l")
    @Nullable
    private final Map<SkinLayer, Boolean> skinLayers;

    public Cosmetic(@NotNull String id2, @NotNull String type2, @NotNull Map<String, String> displayNames, @NotNull CosmeticAssets assets, @Nullable CosmeticSetting[] settings, int storePackageId, @NotNull Map<String, Double> prices, @Nullable Set<@NotNull String> tags, @NotNull DateTime createdAt, @Nullable DateTime availableAfter, @Nullable DateTime availableUntil, @Nullable Map<SkinLayer, Boolean> skinLayers) {
        this.id = id2;
        this.type = type2;
        this.displayNames = displayNames;
        this.assets = assets;
        this.settings = settings;
        this.storePackageId = storePackageId;
        this.prices = prices;
        this.tags = tags;
        this.createdAt = createdAt;
        this.availableAfter = availableAfter;
        this.availableUntil = availableUntil;
        this.skinLayers = skinLayers;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    @Override
    @NotNull
    public Map<String, String> getDisplayNames() {
        return this.displayNames;
    }

    @NotNull
    public CosmeticAssets getAssets() {
        return this.assets;
    }

    @Nullable
    public CosmeticSetting[] getSettings() {
        return this.settings;
    }

    public int getStorePackageId() {
        return this.storePackageId;
    }

    @Override
    @NotNull
    public Map<String, Double> getPrices() {
        return this.prices;
    }

    @NotNull
    public @NotNull Set<@NotNull String> getTags() {
        if (this.tags == null) {
            return Collections.emptySet();
        }
        return this.tags;
    }

    @NotNull
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    public DateTime getAvailableAfter() {
        return this.availableAfter;
    }

    @Nullable
    public DateTime getAvailableUntil() {
        return this.availableUntil;
    }

    @Override
    @Nullable
    public Map<SkinLayer, Boolean> getSkinLayers() {
        return this.skinLayers;
    }

    public boolean hasSettings() {
        return this.settings != null && this.settings.length > 0;
    }

    public boolean isAvailable() {
        return this.availableAfter != null && this.isAvailableAt(new DateTime());
    }

    public boolean isAvailableAt(@NotNull DateTime dateTime) {
        return this.availableAfter != null && this.availableAfter.before(dateTime) && (this.availableUntil == null || this.availableUntil.after(dateTime));
    }
}

