/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics.boxmask;

import gg.essential.cosmetics.boxmask.ModelClipper;
import gg.essential.model.Bone;
import gg.essential.model.Box3;
import gg.essential.model.Cube;
import gg.essential.model.Face;
import gg.essential.model.PositionTexVertex;
import gg.essential.model.Vector3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_243;

public class ModelClipperImpl
implements ModelClipper {
    @Override
    public Bone compute(Bone bone, List<Box3> renderExclusions) {
        if (renderExclusions.isEmpty()) {
            return bone;
        }
        bone = bone.deepCopy();
        this.apply(bone, renderExclusions);
        return bone;
    }

    private void apply(Bone bone, List<Box3> renderExclusions) {
        for (Cube cube : bone.cubeList) {
            Iterator<Face> iterator2 = cube.getQuadList().iterator();
            ArrayList<Face> newFaces = new ArrayList<Face>();
            while (iterator2.hasNext()) {
                Face next = iterator2.next();
                Box3 selfBox = new Box3();
                PositionTexVertex[] vertices = next.vertexPositions;
                class_243 a = vertices[0].vector3D;
                class_243 b = vertices[1].vector3D;
                class_243 c = vertices[2].vector3D;
                class_243 d = vertices[3].vector3D;
                selfBox.setFromPoints(Arrays.asList(new Vector3(a.field_1352, a.field_1351, a.field_1350), new Vector3(b.field_1352, b.field_1351, b.field_1350), new Vector3(c.field_1352, c.field_1351, c.field_1350), new Vector3(d.field_1352, d.field_1351, d.field_1350)));
                boolean matched = false;
                IntersectedFace intersectedFace = new IntersectedFace(next);
                for (Box3 exclusion : renderExclusions) {
                    Box3 intersect = selfBox.clone().intersect(exclusion);
                    if (intersect.equals(selfBox)) {
                        iterator2.remove();
                        matched = false;
                        break;
                    }
                    if (intersect.isEmpty()) continue;
                    matched = true;
                    float xHeight = intersect.getMax().component1() - intersect.getMin().component1();
                    float zHeight = intersect.getMax().component3() - intersect.getMin().component3();
                    float minYIntersect = Math.min(intersect.getMin().y, intersectedFace.aRegion.points[3].vector3.y);
                    if (xHeight == 0.0f) {
                        this.generateARegion(intersectedFace, minYIntersect);
                        continue;
                    }
                    if (zHeight != 0.0f) continue;
                    this.generateARegion(intersectedFace, minYIntersect);
                }
                if (!matched) continue;
                iterator2.remove();
                newFaces.addAll(intersectedFace.generateFaces());
            }
            cube.getQuadList().addAll(newFaces);
        }
        if (bone.childModels != null) {
            for (Bone childModel : bone.childModels) {
                this.apply(childModel, renderExclusions);
            }
        }
    }

    private void generateARegion(IntersectedFace intersectedFace, float minYIntersect) {
        intersectedFace.aRegion.points[2].vector3.y = intersectedFace.aRegion.points[3].vector3.y = minYIntersect;
        intersectedFace.aRegion.points[2].texturePositionY = intersectedFace.aRegion.points[3].texturePositionY = intersectedFace.aRegion.points[1].texturePositionY + (minYIntersect - intersectedFace.aRegion.points[0].vector3.y) / intersectedFace.aRegion.spacialYDistance * intersectedFace.aRegion.textureYDistance;
    }

    private static class IntersectedFace {
        private FaceRegion aRegion;

        public IntersectedFace(Face base) {
            this.aRegion = new FaceRegion(EnumRegion.A, base);
        }

        public List<Face> generateFaces() {
            return Collections.singletonList(this.aRegion.toFace());
        }
    }

    private static class FaceRegion {
        public Point[] points;
        public float spacialYDistance;
        public float textureYDistance;

        public FaceRegion(EnumRegion region, Face base) {
            PositionTexVertex[] vertexPositions = base.vertexPositions;
            this.points = new Point[vertexPositions.length];
            for (int i = 0; i < vertexPositions.length; ++i) {
                this.points[i] = new Point(vertexPositions[i]);
            }
            if (region == EnumRegion.A) {
                this.spacialYDistance = this.points[2].vector3.y - this.points[1].vector3.y;
                this.textureYDistance = this.points[2].texturePositionY - this.points[1].texturePositionY;
            }
        }

        public Face toFace() {
            PositionTexVertex[] vertex = new PositionTexVertex[this.points.length];
            for (int i = 0; i < vertex.length; ++i) {
                vertex[i] = this.points[i].toPositionTexVertex();
            }
            return new Face(vertex);
        }
    }

    private static class Point {
        public float texturePositionX;
        public float texturePositionY;
        public Vector3 vector3;

        public Point(PositionTexVertex vertex) {
            this.texturePositionX = vertex.texturePositionX;
            this.texturePositionY = vertex.texturePositionY;
            this.vector3 = new Vector3(vertex.vector3D.field_1352, vertex.vector3D.field_1351, vertex.vector3D.field_1350);
        }

        public PositionTexVertex toPositionTexVertex() {
            return new PositionTexVertex(new class_243((double)this.vector3.x, (double)this.vector3.y, (double)this.vector3.z), this.texturePositionX, this.texturePositionY);
        }
    }

    private static enum EnumRegion {
        A,
        B,
        C,
        D;

    }
}

