/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics;

import gg.essential.Essential;
import gg.essential.connectionmanager.common.packet.cosmetic.ClientCosmeticAnimationTriggerPacket;
import gg.essential.cosmetics.events.AnimationEvent;
import gg.essential.cosmetics.events.AnimationEventType;
import gg.essential.cosmetics.events.AnimationTarget;
import gg.essential.cosmetics.model.Cosmetic;
import gg.essential.cosmetics.model.CosmeticType;
import gg.essential.gui.common.EmulatedUI3DPlayer;
import gg.essential.model.BedrockModel;
import gg.essential.model.ModelAnimationState;
import gg.essential.model.ModelInstance;
import gg.essential.model.PlayerMolangQuery;
import gg.essential.model.RenderMetadata;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.subscription.SubscriptionManager;
import gg.essential.universal.UMatrixStack;
import gg.essential.util.UUIDUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.collections.CollectionsKt;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

public class WearableBedrockModel {
    private static final Random random = new Random();
    public static Map<UUID, Set<WeakReference<WearableBedrockModel>>> models = new ConcurrentHashMap<UUID, Set<WeakReference<WearableBedrockModel>>>();
    private final ModelInstance model;
    private final Set<AnimationEvent> ongoingAnimations = new HashSet<AnimationEvent>();
    private final AnimationEffectStates animationStates = new AnimationEffectStates();
    private final Cosmetic cosmetic;
    private final boolean isSelf;
    private float lastFrame = 0.0f;

    public WearableBedrockModel(Cosmetic cosmetic, class_742 player2) {
        this.model = new ModelInstance(cosmetic, player2);
        this.cosmetic = cosmetic;
        this.isSelf = player2.method_5667().equals(UUIDUtil.getClientUUID()) && !(player2 instanceof EmulatedUI3DPlayer.EmulatedPlayer);
        models.computeIfAbsent(player2.method_5667(), uuid -> Collections.newSetFromMap(new ConcurrentHashMap())).add(new WeakReference<WearableBedrockModel>(this));
        this.processEvent(AnimationEventType.IDLE);
    }

    public ModelInstance getModel() {
        return this.model;
    }

    public PlayerMolangQuery getQuery() {
        return (PlayerMolangQuery)this.model.getEntity();
    }

    public void render(UMatrixStack matrixStack, BedrockModel.UVertexConsumerProvider vertexConsumerProvider, RenderMetadata renderMetadata) {
        this.maybeFireTextureAnimationStartEvent();
        AnimationEvent highestPriority = this.getHighestPriority();
        ArrayList onComplete = new ArrayList();
        this.ongoingAnimations.removeIf(ongoingAnimation -> {
            for (ModelAnimationState.AnimationState animationState : this.model.getAnimationState().getActive()) {
                boolean remove2;
                if (!animationState.getAnimation().getName().equals(ongoingAnimation.getName()) || ongoingAnimation.getLoops() <= 0) continue;
                boolean bl = remove2 = animationState.getAnimTime() > animationState.getAnimation().getAnimationLength() * (float)ongoingAnimation.getLoops();
                if (remove2 && ongoingAnimation.getOnComplete() != null) {
                    onComplete.add(ongoingAnimation.getOnComplete());
                }
                return remove2;
            }
            return false;
        });
        this.ongoingAnimations.addAll(onComplete);
        this.model.getAnimationState().getActive().removeIf(animationState -> {
            AnimationEvent animationByName = this.getAnimationByName(animationState.getAnimation().getName());
            return animationByName != highestPriority;
        });
        if (this.model.getAnimationState().getActive().isEmpty() && highestPriority != null) {
            this.model.startAnimation(highestPriority.getName());
        }
        this.model.render(matrixStack, vertexConsumerProvider, renderMetadata);
    }

    private AnimationEvent getHighestPriority() {
        return CollectionsKt.maxByOrNull(this.ongoingAnimations, AnimationEvent::getPriority);
    }

    private AnimationEvent getAnimationByName(String name) {
        for (AnimationEvent ongoingAnimation : this.ongoingAnimations) {
            if (!ongoingAnimation.getName().equals(name)) continue;
            return ongoingAnimation;
        }
        return null;
    }

    public void processEvent(AnimationEventType type2) {
        AnimationEvent[] animationEvents = this.model.getModel().getAnimationEvents();
        AnimationEvent highestPriority = this.getHighestPriority();
        int priority = highestPriority == null ? 0 : highestPriority.getPriority();
        for (AnimationEvent event : animationEvents) {
            ConnectionManager connectionManager;
            CosmeticType cosmeticType;
            if (priority > event.getPriority() || event.getType() != type2 || event.getTarget() != AnimationTarget.ALL && (event.getTarget() == AnimationTarget.SELF && !(this.getQuery().getPlayer() instanceof class_746) && !(this.getQuery().getPlayer() instanceof EmulatedUI3DPlayer.EmulatedPlayer) || event.getTarget() == AnimationTarget.OTHERS && this.getQuery().getPlayer() instanceof class_746) || event.getSkips() != 0 && this.animationStates.skips.compute(event, (animationEvent, integer) -> {
                if (integer == null) {
                    return 1;
                }
                return integer + 1;
            }) % event.getSkips() != 0 || !this.handleProbability(event)) continue;
            if (this.isSelf && (cosmeticType = (connectionManager = Essential.getInstance().getConnectionManager()).getCosmeticsManager().getCosmeticType(this.cosmetic)) != null) {
                connectionManager.send(new ClientCosmeticAnimationTriggerPacket(cosmeticType.getSlot(), event.getName()));
            }
            this.ongoingAnimations.add(event);
        }
    }

    public void fireTriggerFromAnimation(String animationName) {
        if (animationName.equals("texture_start")) {
            this.model.syncTextureStart();
            return;
        }
        for (AnimationEvent animationEvent : this.model.getModel().getAnimationEvents()) {
            if (!animationEvent.getName().equals(animationName)) continue;
            this.ongoingAnimations.add(animationEvent);
            break;
        }
    }

    private void maybeFireTextureAnimationStartEvent() {
        BedrockModel model = this.model.getModel();
        float totalFrames = (float)model.getTotalHeight() / model.getRootBone().textureWidth;
        int frame = (int)(this.getQuery().getLifeTime() * 7.0f);
        if ((float)frame % totalFrames < this.lastFrame) {
            ConnectionManager connectionManager;
            CosmeticType cosmeticType;
            if (this.isSelf && (cosmeticType = (connectionManager = Essential.getInstance().getConnectionManager()).getCosmeticsManager().getCosmeticType(this.cosmetic)) != null) {
                connectionManager.send(new ClientCosmeticAnimationTriggerPacket(cosmeticType.getSlot(), "texture_start"));
            }
            this.processEvent(AnimationEventType.TEXTURE_ANIMATION_START);
        }
        this.lastFrame = (float)frame % totalFrames;
    }

    private boolean handleProbability(AnimationEvent event) {
        return (double)event.getProbability() > random.nextDouble();
    }

    public Cosmetic getCosmetic() {
        return this.cosmetic;
    }

    static class AnimationEffectStates {
        HashMap<AnimationEvent, Integer> skips = new HashMap();

        AnimationEffectStates() {
        }
    }

    public static class Cleanup
    implements SubscriptionManager.Listener {
        @Override
        public void onSubscriptionRemoved(@NotNull Set<UUID> uuids) {
            for (UUID uuid : uuids) {
                models.remove(uuid);
            }
        }
    }
}

