/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import gg.essential.Essential;
import gg.essential.cosmetics.CosmeticSlot;
import gg.essential.cosmetics.SkinLayer;
import gg.essential.cosmetics.WearableBedrockModel;
import gg.essential.cosmetics.events.AnimationEventType;
import gg.essential.cosmetics.model.Cosmetic;
import gg.essential.cosmetics.model.CosmeticSetting;
import gg.essential.cosmetics.skinmask.MaskedSkinProvider;
import gg.essential.cosmetics.source.CosmeticsSource;
import gg.essential.event.entity.PlayerTickEvent;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.mixins.impl.client.entity.AbstractClientPlayerExt;
import gg.essential.model.EnumPart;
import gg.essential.model.Vector3;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsManager;
import gg.essential.util.ExtensionsKt;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1657;
import net.minecraft.class_742;

public class PlayerWearableManager {
    private final CosmeticsManager cosmeticsManager;

    public PlayerWearableManager(CosmeticsManager cosmeticsManager) {
        this.cosmeticsManager = cosmeticsManager;
    }

    @Subscribe
    public void tick(PlayerTickEvent tickEvent) {
        if (!tickEvent.isPre()) {
            return;
        }
        class_1657 playerEntity = tickEvent.getPlayer();
        if (!(playerEntity instanceof class_742)) {
            return;
        }
        class_742 player2 = (class_742)playerEntity;
        this.updateCosmetics(player2);
    }

    private void updateCosmetics(class_742 player2) {
        AbstractClientPlayerExt playerExt = (AbstractClientPlayerExt)player2;
        CosmeticsSource cosmeticsSource = playerExt.getCosmeticsSource();
        String newSkinType = player2.method_3121();
        String oldSkinType = playerExt.getEssentialCosmeticsSkinType();
        ImmutableMap<CosmeticSlot, String> newCosmetics = cosmeticsSource.getCosmetics();
        ImmutableMap<CosmeticSlot, String> oldCosmetics = playerExt.getEssentialCosmetics();
        ImmutableMap<String, ImmutableList<CosmeticSetting>> newSettings = cosmeticsSource.getCosmeticSettings();
        ImmutableMap<String, ImmutableList<CosmeticSetting>> oldSettings = playerExt.getEssentialCosmeticSettings();
        Set<EnumPart> newArmour = playerExt.getModelRenderState().getArmourFromPlayer(player2);
        Set<EnumPart> oldArmour = playerExt.getCachedArmour();
        if (Objects.equals(newCosmetics, oldCosmetics) && Objects.equals(newSkinType, oldSkinType) && Objects.equals(newSettings, oldSettings) && Objects.equals(oldArmour, newArmour)) {
            return;
        }
        HashSet newCosmeticIds = new HashSet(newCosmetics.values());
        Map<Cosmetic, WearableBedrockModel> models = playerExt.getEssentialCosmeticModels();
        if (!Objects.equals(newSkinType, oldSkinType)) {
            models.clear();
        }
        models.keySet().removeIf(it -> !newCosmeticIds.contains(it.getId()) || this.cosmeticsManager.getCosmetic(it.getId()) != it);
        HashMap<String, Vector3> positionAdjustments = new HashMap<String, Vector3>();
        HashSet<CosmeticSetting> settingsForSkinMask = new HashSet<CosmeticSetting>();
        boolean allUpdated = true;
        for (Object cosmeticId : newCosmeticIds) {
            List cosmeticSettings;
            Cosmetic cosmetic = this.cosmeticsManager.getCosmetic((String)cosmeticId);
            if (cosmetic == null) {
                allUpdated = false;
                continue;
            }
            Vector3 positionAdjustment = new Vector3(0.0f, 0.0f, 0.0f);
            if (newSettings != null && (cosmeticSettings = (List)newSettings.get(cosmeticId)) != null && !cosmeticSettings.isEmpty()) {
                for (CosmeticSetting cosmeticSetting : cosmeticSettings) {
                    if (!"PLAYER_POSITION_ADJUSTMENT".equals(cosmeticSetting.getType())) continue;
                    if (cosmeticSetting.hasData("x")) {
                        positionAdjustment.x = ((Number)cosmeticSetting.getData("x")).intValue();
                    }
                    if (cosmeticSetting.hasData("y")) {
                        positionAdjustment.y = ((Number)cosmeticSetting.getData("y")).intValue();
                    }
                    if (cosmeticSetting.hasData("z")) {
                        positionAdjustment.z = ((Number)cosmeticSetting.getData("z")).intValue();
                    }
                    settingsForSkinMask.add(cosmeticSetting);
                }
            }
            positionAdjustments.put((String)cosmeticId, positionAdjustment);
            if (models.containsKey(cosmetic)) continue;
            CompletableFuture<Boolean> cosmeticReadyStatus = this.cosmeticsManager.getCosmeticReadyStatus(cosmetic);
            if (!cosmeticReadyStatus.isDone()) {
                allUpdated = false;
                continue;
            }
            if (!cosmeticReadyStatus.join().booleanValue()) continue;
            WearableBedrockModel model = new WearableBedrockModel(cosmetic, player2);
            model.processEvent(AnimationEventType.EQUIP);
            models.put(cosmetic, model);
        }
        playerExt.setEssentialCosmetics((ImmutableMap<CosmeticSlot, String>)(allUpdated ? newCosmetics : null));
        playerExt.setEssentialCosmeticSettings(newSettings);
        playerExt.setEssentialCosmeticsSkinType(newSkinType);
        playerExt.getModelRenderState().updatePositionAdjustments(positionAdjustments);
        Set<SkinLayer> coveredLayers = playerExt.getCoveredLayers();
        coveredLayers.clear();
        for (Cosmetic cosmetic : models.keySet()) {
            coveredLayers.addAll(ExtensionsKt.getCoveredSkinLayers(cosmetic, this.cosmeticsManager));
            CosmeticSetting[] cosmeticSettings = cosmetic.getSettings();
            if (cosmeticSettings != null) continue;
            Essential.logger.error(cosmetic.getDisplayName("en_us") + " had null settings!");
        }
        boolean anyMasks = models.keySet().stream().anyMatch(it -> it.getAssets().getSkinMask() != null);
        if (anyMasks) {
            playerExt.cosmeticMaskConfig(new MaskedSkinProvider.Config(models, settingsForSkinMask, newArmour));
        } else {
            playerExt.cosmeticMaskConfig(null);
        }
    }
}

