/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import gg.essential.Essential;
import gg.essential.cosmetics.WearableBedrockModel;
import gg.essential.cosmetics.model.CosmeticSetting;
import gg.essential.cosmetics.skinmask.SkinPartSetting;
import gg.essential.model.Box3;
import gg.essential.model.EnumPart;
import gg.essential.model.Side;
import gg.essential.model.Vector3;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_742;
import org.jetbrains.annotations.Nullable;

public class PlayerModelRenderState {
    private final Map<String, List<EnumPart>> hiddenParts = new HashMap<String, List<EnumPart>>();
    private final Map<String, Set<String>> hiddenBones = new HashMap<String, Set<String>>();
    private final Map<String, SkinPartSetting> modelShifts = new HashMap<String, SkinPartSetting>();
    private final UUID player;
    private Map<String, Vector3> positionAdjustments = new HashMap<String, Vector3>();
    private Collection<WearableBedrockModel> lastConfig = null;
    private List<Box3> cachedExclusions = null;

    public PlayerModelRenderState(UUID player2) {
        this.player = player2;
    }

    private boolean isNotEmpty(class_1799 stack) {
        return !stack.method_7960();
    }

    public Set<EnumPart> getArmourFromPlayer(class_742 player2) {
        class_1661 inventory = player2.method_31548();
        HashSet<EnumPart> equippedSlots = new HashSet<EnumPart>();
        if (this.isNotEmpty(inventory.method_7372(0)) || this.isNotEmpty(inventory.method_7372(1))) {
            equippedSlots.add(EnumPart.LEFT_LEG);
            equippedSlots.add(EnumPart.RIGHT_LEG);
        }
        if (this.isNotEmpty(inventory.method_7372(2))) {
            equippedSlots.add(EnumPart.LEFT_ARM);
            equippedSlots.add(EnumPart.RIGHT_ARM);
            equippedSlots.add(EnumPart.BODY);
        }
        if (this.isNotEmpty(inventory.method_7372(3))) {
            equippedSlots.add(EnumPart.HEAD);
        }
        return equippedSlots;
    }

    public Map<String, Set<String>> getHiddenBones() {
        return this.hiddenBones;
    }

    public Map<String, List<EnumPart>> getHiddenParts(Collection<WearableBedrockModel> values2, Collection<EnumPart> armour) {
        if (this.cachedExclusions == null || !this.lastConfig.equals(values2)) {
            this.cachedExclusions = new ArrayList<Box3>();
            this.hiddenParts.clear();
            this.hiddenBones.clear();
            for (WearableBedrockModel model : values2) {
                this.cachedExclusions.addAll(model.getModel().getRenderExclusions());
                @Nullable CosmeticSetting[] settings = model.getCosmetic().getSettings();
                if (settings == null) continue;
                for (CosmeticSetting setting : settings) {
                    if (setting == null) continue;
                    List enumParts = this.hiddenParts.computeIfAbsent(setting.getId(), s -> new ArrayList());
                    if ("cosmetic_bone_hiding".equalsIgnoreCase(setting.getType())) {
                        if (setting.hasData("head") && ((Boolean)setting.getData("head")).booleanValue()) {
                            enumParts.add(EnumPart.HEAD);
                            continue;
                        }
                        if (setting.hasData("body") && ((Boolean)setting.getData("body")).booleanValue()) {
                            enumParts.add(EnumPart.BODY);
                            continue;
                        }
                        if (setting.hasData("arms") && ((Boolean)setting.getData("arms")).booleanValue()) {
                            enumParts.add(EnumPart.LEFT_ARM);
                            enumParts.add(EnumPart.RIGHT_ARM);
                            continue;
                        }
                        if (!setting.hasData("legs") || !((Boolean)setting.getData("legs")).booleanValue()) continue;
                        enumParts.add(EnumPart.LEFT_LEG);
                        enumParts.add(EnumPart.RIGHT_LEG);
                        continue;
                    }
                    if ("armor_handling".equalsIgnoreCase(setting.getType())) {
                        if (setting.hasData("head") && ((Boolean)setting.getData("head")).booleanValue() && armour.contains((Object)EnumPart.HEAD)) {
                            enumParts.add(EnumPart.HEAD);
                        }
                        if (setting.hasData("body") && ((Boolean)setting.getData("body")).booleanValue() && armour.contains((Object)EnumPart.BODY)) {
                            enumParts.add(EnumPart.BODY);
                        }
                        if (setting.hasData("arms") && ((Boolean)setting.getData("arms")).booleanValue()) {
                            if (armour.contains((Object)EnumPart.LEFT_ARM)) {
                                enumParts.add(EnumPart.LEFT_ARM);
                            }
                            if (armour.contains((Object)EnumPart.RIGHT_ARM)) {
                                enumParts.add(EnumPart.RIGHT_ARM);
                            }
                        }
                        if (!setting.hasData("legs") || !((Boolean)setting.getData("legs")).booleanValue()) continue;
                        if (armour.contains((Object)EnumPart.LEFT_LEG)) {
                            enumParts.add(EnumPart.LEFT_LEG);
                        }
                        if (!armour.contains((Object)EnumPart.RIGHT_LEG)) continue;
                        enumParts.add(EnumPart.RIGHT_LEG);
                        continue;
                    }
                    if (!"external_hidden_bone".equalsIgnoreCase(setting.getType())) continue;
                    this.hiddenBones.computeIfAbsent(setting.getId(), s -> new HashSet()).addAll(setting.getData().keySet());
                }
            }
            this.lastConfig = new ArrayList<WearableBedrockModel>(values2);
        }
        return this.hiddenParts;
    }

    public List<Box3> getCachedExclusions() {
        return this.cachedExclusions;
    }

    public Map<String, SkinPartSetting> getModelShifts() {
        return this.modelShifts;
    }

    public void updatePositionAdjustments(Map<String, Vector3> data2) {
        this.positionAdjustments = data2;
    }

    public Vector3 positionAdjustments(String cosmeticId) {
        return this.positionAdjustments.getOrDefault(cosmeticId, new Vector3());
    }

    public Side getCosmeticSide(String cosmeticId) {
        CosmeticsManager cosmeticsManager = Essential.getInstance().getConnectionManager().getCosmeticsManager();
        ImmutableMap<String, ImmutableList<CosmeticSetting>> cosmeticSettings = cosmeticsManager.getCosmeticSettings(this.player);
        if (cosmeticSettings == null || !cosmeticSettings.containsKey((Object)cosmeticId)) {
            return null;
        }
        for (CosmeticSetting cosmeticSetting : (ImmutableList)cosmeticSettings.get((Object)cosmeticId)) {
            if (!"SIDE".equals(cosmeticSetting.getType()) || !cosmeticSetting.hasData("SIDE")) continue;
            return Side.valueOf((String)cosmeticSetting.getData("SIDE"));
        }
        return null;
    }
}

