/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics;

import gg.essential.Essential;
import gg.essential.config.EssentialConfig;
import gg.essential.cosmetics.CosmeticSlot;
import gg.essential.cosmetics.PlayerModelRenderState;
import gg.essential.cosmetics.WearableBedrockModel;
import gg.essential.cosmetics.model.Cosmetic;
import gg.essential.cosmetics.model.CosmeticType;
import gg.essential.data.OnboardingData;
import gg.essential.mixins.impl.client.entity.AbstractClientPlayerExt;
import gg.essential.model.BedrockModel;
import gg.essential.model.Box3;
import gg.essential.model.EnumPart;
import gg.essential.model.RenderMetadata;
import gg.essential.model.Vector3;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsManager;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UMinecraft;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_591;
import net.minecraft.class_742;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EssentialModelRenderer
extends class_3887<class_742, class_591<class_742>> {
    public EssentialModelRenderer(class_3883<class_742, class_591<class_742>> renderer) {
        super(renderer);
    }

    public static boolean cosmeticsShouldRender(class_1657 player2) {
        if (EssentialConfig.INSTANCE.getHideCosmeticsWhenServerOverridesSkin() && player2 instanceof class_742 && ((AbstractClientPlayerExt)player2).isSkinOverrodeByServer()) {
            return false;
        }
        double distance = player2.method_5739((class_1297)UMinecraft.getMinecraft().field_1724);
        return !player2.method_5767() && !player2.method_7325() && distance < 4096.0;
    }

    public void render(UMatrixStack matrixStack, BedrockModel.UVertexConsumerProvider vertexConsumerProvider, @Nullable Set<EnumPart> parts, @NotNull class_742 player2, int light, float scale) {
        if (!OnboardingData.hasAcceptedTos()) {
            return;
        }
        if (!EssentialModelRenderer.cosmeticsShouldRender((class_1657)player2)) {
            return;
        }
        AbstractClientPlayerExt abstractClientPlayerExt = (AbstractClientPlayerExt)player2;
        PlayerModelRenderState playerModelRenderState = abstractClientPlayerExt.getModelRenderState();
        Map<Cosmetic, WearableBedrockModel> models = abstractClientPlayerExt.getEssentialCosmeticModels();
        if (models.isEmpty()) {
            return;
        }
        matrixStack.push();
        if (parts == null) {
            parts = new HashSet<EnumPart>(Arrays.asList(EnumPart.values()));
        }
        matrixStack.translate(0.0f, 1.501f, 0.0f);
        Collection<WearableBedrockModel> values2 = models.values();
        Map<String, List<EnumPart>> hiddenParts = playerModelRenderState.getHiddenParts(values2, playerModelRenderState.getArmourFromPlayer(player2));
        Map<String, Set<String>> hiddenBones = playerModelRenderState.getHiddenBones();
        for (WearableBedrockModel model : values2) {
            List<EnumPart> enumParts = hiddenParts.get(model.getCosmetic().getId());
            HashSet<EnumPart> modelParts = new HashSet<EnumPart>(parts);
            if (enumParts != null) {
                enumParts.forEach(modelParts::remove);
            }
            Vector3 positionAdjustment = playerModelRenderState.positionAdjustments(model.getCosmetic().getId());
            Set<String> modelHiddenBones = hiddenBones.getOrDefault(model.getCosmetic().getId(), Collections.emptySet());
            List<Box3> cachedExclusions = playerModelRenderState.getCachedExclusions();
            CosmeticsManager cosmeticsManager = Essential.getInstance().getConnectionManager().getCosmeticsManager();
            CosmeticType cosmeticType = cosmeticsManager.getCosmeticType(model.getCosmetic());
            if (cosmeticType == null || cosmeticType.getSlot() != CosmeticSlot.FULL_BODY && cosmeticType.getSlot() != CosmeticSlot.SUITS) {
                cachedExclusions = new ArrayList<Box3>();
            }
            RenderMetadata renderMetadata = new RenderMetadata(player2, light, scale, playerModelRenderState.getCosmeticSide(model.getCosmetic().getId()), modelHiddenBones, false, cachedExclusions, positionAdjustment, modelParts);
            model.render(matrixStack, vertexConsumerProvider, renderMetadata);
        }
        matrixStack.pop();
    }

    public void render(@NotNull class_4587 vMatrixStack, @NotNull class_4597 buffer, int light, @NotNull class_742 player2, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        UMatrixStack matrixStack = new UMatrixStack(vMatrixStack);
        BedrockModel.UVertexConsumerProvider vertexConsumerProvider = new BedrockModel.UVertexConsumerProvider(buffer);
        float scale = 0.0625f;
        this.render(matrixStack, vertexConsumerProvider, null, player2, light, scale);
    }
}

