/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.connectionmanager.common.packet.subscription;

import com.google.gson.annotations.SerializedName;
import gg.essential.connectionmanager.common.packet.Packet;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubscriptionUpdatePacket
extends Packet {
    @SerializedName(value="a")
    @Nullable
    private final UUID[] uuids;
    @SerializedName(value="b")
    private final boolean unsubscribeFromAll;
    @SerializedName(value="c")
    private final boolean newSubscription;

    public SubscriptionUpdatePacket(boolean unsubscribeFromAll) {
        this(null, unsubscribeFromAll, false);
    }

    public SubscriptionUpdatePacket(@NotNull UUID[] uuids, boolean newSubscription) {
        this(uuids, false, newSubscription);
    }

    SubscriptionUpdatePacket(@Nullable UUID[] uuids, boolean unsubscribeFromAll, boolean newSubscription) {
        this.uuids = uuids;
        this.unsubscribeFromAll = unsubscribeFromAll;
        this.newSubscription = newSubscription;
    }

    @Nullable
    public UUID[] getUUIDs() {
        return this.uuids;
    }

    public boolean isUnsubscribeFromAll() {
        return this.unsubscribeFromAll;
    }

    public boolean isNewSubscription() {
        return this.newSubscription;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionUpdatePacket that = (SubscriptionUpdatePacket)o;
        return this.unsubscribeFromAll == that.unsubscribeFromAll && this.newSubscription == that.newSubscription && Arrays.equals(this.uuids, that.uuids);
    }

    public int hashCode() {
        int result2 = Objects.hash(this.unsubscribeFromAll, this.newSubscription);
        result2 = 31 * result2 + Arrays.hashCode(this.uuids);
        return result2;
    }

    public String toString() {
        return "SubscribeUpdateEvent{uuids=" + Arrays.toString(this.uuids) + ", unsubscribeFromAll=" + this.unsubscribeFromAll + ", newSubscription=" + this.newSubscription + '}';
    }
}

