/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.connectionmanager.common.packet.mod;

import com.google.gson.annotations.SerializedName;
import gg.essential.connectionmanager.common.packet.Packet;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientModsAnnouncePacket
extends Packet {
    @SerializedName(value="b")
    @NotNull
    private final String minecraftVersion;
    @SerializedName(value="a")
    @NotNull
    private final String[] modChecksums;
    @SerializedName(value="c")
    @NotNull
    private final Platform platform;
    @SerializedName(value="d")
    @NotNull
    private final String platformVersion;

    public ClientModsAnnouncePacket(@NotNull String minecraftVersion, @NotNull String[] modChecksums, @NotNull Platform platform, @NotNull String platformVersion) {
        this.minecraftVersion = minecraftVersion;
        this.modChecksums = modChecksums;
        this.platform = platform;
        this.platformVersion = platformVersion;
    }

    @NotNull
    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    @NotNull
    public String[] getModChecksums() {
        return this.modChecksums;
    }

    @NotNull
    public Platform getPlatform() {
        return this.platform;
    }

    @NotNull
    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientModsAnnouncePacket that = (ClientModsAnnouncePacket)o;
        return this.minecraftVersion.equals(that.minecraftVersion) && Arrays.equals(this.modChecksums, that.modChecksums) && this.platform == that.platform && this.platformVersion.equals(that.platformVersion);
    }

    public int hashCode() {
        int result2 = Objects.hash(new Object[]{this.minecraftVersion, this.platform, this.platformVersion});
        result2 = 31 * result2 + Arrays.hashCode(this.modChecksums);
        return result2;
    }

    public String toString() {
        return "ModsAnnouncePacket{minecraftVersion=" + this.minecraftVersion + ", modChecksums=" + Arrays.toString(this.modChecksums) + ", platform=" + (Object)((Object)this.platform) + ", platformVersion='" + this.platformVersion + '\'' + '}';
    }

    public static enum Platform {
        FORGE,
        FABRIC;

    }
}

