/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.connectionmanager.common.model.relationships;

import com.google.gson.annotations.SerializedName;
import com.sparkuniverse.toolbox.relationships.enums.RelationshipState;
import com.sparkuniverse.toolbox.relationships.enums.RelationshipType;
import com.sparkuniverse.toolbox.util.DateTime;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class Relationship {
    @SerializedName(value="a")
    @NotNull
    private final UUID senderUUID;
    @SerializedName(value="b")
    @NotNull
    private final UUID targetUUID;
    @SerializedName(value="c")
    @NotNull
    private final RelationshipType type;
    @SerializedName(value="d")
    @NotNull
    private final RelationshipState state;
    @SerializedName(value="e")
    @NotNull
    private final DateTime since;

    public Relationship(@NotNull UUID senderUUID, @NotNull UUID targetUUID, @NotNull RelationshipType type2, @NotNull RelationshipState state, @NotNull DateTime since) {
        this.senderUUID = senderUUID;
        this.targetUUID = targetUUID;
        this.type = type2;
        this.state = state;
        this.since = since;
    }

    @NotNull
    public UUID getSenderUUID() {
        return this.senderUUID;
    }

    @NotNull
    public UUID getTargetUUID() {
        return this.targetUUID;
    }

    @NotNull
    public UUID getSecondUUID(@NotNull UUID firstUUID) {
        return this.senderUUID.equals(firstUUID) ? this.targetUUID : this.senderUUID;
    }

    @NotNull
    public RelationshipType getType() {
        return this.type;
    }

    @NotNull
    public RelationshipState getState() {
        return this.state;
    }

    @NotNull
    public DateTime getSince() {
        return this.since;
    }

    public boolean isPending() {
        return RelationshipState.PENDING == this.state;
    }

    public String toString() {
        return "Relationship{senderUUID=" + this.senderUUID + ", targetUUID=" + this.targetUUID + ", type=" + (Object)((Object)this.type) + ", state=" + (Object)((Object)this.state) + ", since=" + this.since + '}';
    }
}

