/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.api.utils;

import gg.essential.api.utils.JsonHolder;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001aJ'\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011R(\u0010\u0013\u001a\u00020\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0018\n\u0004\b\u0013\u0010\u0014\u0012\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lgg/essential/api/utils/WebUtil;", "", "", "url", "Ljava/io/File;", "file", "userAgent", "", "downloadToFile", "(Ljava/lang/String;Ljava/io/File;Ljava/lang/String;)V", "Lgg/essential/api/utils/JsonHolder;", "fetchJSON", "(Ljava/lang/String;)Lgg/essential/api/utils/JsonHolder;", "fetchString", "(Ljava/lang/String;)Ljava/lang/String;", "Ljava/io/InputStream;", "setup", "(Ljava/lang/String;Ljava/lang/String;)Ljava/io/InputStream;", "", "LOG", "Z", "getLOG", "()Z", "setLOG", "(Z)V", "getLOG$annotations", "()V", "<init>", "EssentialAPI 1.19-fabric"})
public final class WebUtil {
    @NotNull
    public static final WebUtil INSTANCE = new WebUtil();
    private static boolean LOG;

    private WebUtil() {
    }

    public static final boolean getLOG() {
        return LOG;
    }

    public static final void setLOG(boolean bl) {
        LOG = bl;
    }

    @JvmStatic
    public static /* synthetic */ void getLOG$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final JsonHolder fetchJSON(@NotNull String url) {
        Intrinsics.checkNotNullParameter(url, "url");
        return new JsonHolder(WebUtil.fetchString(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final String fetchString(@NotNull String url) {
        Intrinsics.checkNotNullParameter(url, "url");
        String escapedUrl = StringsKt.replace$default(url, " ", "%20", false, 4, null);
        if (LOG) {
            System.out.println((Object)("Fetching " + escapedUrl));
        }
        try {
            Closeable closeable = WebUtil.setup(escapedUrl, "Mozilla/4.76 (Essential)");
            Throwable throwable = null;
            try {
                InputStream setup2 = (InputStream)closeable;
                boolean bl = false;
                String string = IOUtils.toString((InputStream)setup2, (Charset)Charset.defaultCharset());
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Exception e) {
            System.out.println((Object)("Failed to fetch from " + url));
            e.printStackTrace();
            return "Failed to fetch";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void downloadToFile(@NotNull String url, @NotNull File file, @NotNull String userAgent) throws IOException {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(userAgent, "userAgent");
        Closeable closeable = new FileOutputStream(file);
        Throwable throwable = null;
        try {
            FileOutputStream output = (FileOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new BufferedInputStream(WebUtil.setup(url, userAgent));
            Throwable throwable2 = null;
            try {
                BufferedInputStream input2 = (BufferedInputStream)closeable2;
                boolean bl2 = false;
                byte[] dataBuffer = new byte[1024];
                int bytesRead = 0;
                while (true) {
                    int n;
                    int it = n = input2.read(dataBuffer, 0, 1024);
                    boolean bl3 = false;
                    bytesRead = it;
                    if (n == -1) break;
                    output.write(dataBuffer, 0, bytesRead);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally(closeable2, throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    @JvmStatic
    private static final InputStream setup(String url, String userAgent) throws IOException {
        URLConnection uRLConnection = new URL(url).openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        connection.setRequestMethod("GET");
        connection.setUseCaches(true);
        connection.addRequestProperty("User-Agent", userAgent);
        connection.setReadTimeout(15000);
        connection.setConnectTimeout(15000);
        connection.setDoOutput(true);
        InputStream inputStream = connection.getInputStream();
        Intrinsics.checkNotNullExpressionValue(inputStream, "connection.inputStream");
        return inputStream;
    }
}

