/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.api.utils;

import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b(\u0010 J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J+\u0010\r\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ1\u0010\r\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u0010J\u0019\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\"\u0010\u0015\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u001a\u0010!\u001a\u00020\u00148FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001f\u0010 \u001a\u0004\b\u001e\u0010\u0018R \u0010#\u001a\u00020\"8\u0006X\u0087\u0004\u00a2\u0006\u0012\n\u0004\b#\u0010$\u0012\u0004\b'\u0010 \u001a\u0004\b%\u0010&\u00a8\u0006)"}, d2={"Lgg/essential/api/utils/Multithreading;", "", "Ljava/lang/Runnable;", "runnable", "", "runAsync", "(Ljava/lang/Runnable;)V", "r", "", "delay", "Ljava/util/concurrent/TimeUnit;", "unit", "Ljava/util/concurrent/ScheduledFuture;", "schedule", "(Ljava/lang/Runnable;JLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;", "initialDelay", "(Ljava/lang/Runnable;JJLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;", "Ljava/util/concurrent/Future;", "submit", "(Ljava/lang/Runnable;)Ljava/util/concurrent/Future;", "Ljava/util/concurrent/ThreadPoolExecutor;", "POOL", "Ljava/util/concurrent/ThreadPoolExecutor;", "getPOOL", "()Ljava/util/concurrent/ThreadPoolExecutor;", "setPOOL", "(Ljava/util/concurrent/ThreadPoolExecutor;)V", "Ljava/util/concurrent/atomic/AtomicInteger;", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getPool", "getPool$annotations", "()V", "pool", "Ljava/util/concurrent/ScheduledExecutorService;", "scheduledPool", "Ljava/util/concurrent/ScheduledExecutorService;", "getScheduledPool", "()Ljava/util/concurrent/ScheduledExecutorService;", "getScheduledPool$annotations", "<init>", "EssentialAPI 1.19-fabric"})
public final class Multithreading {
    @NotNull
    public static final Multithreading INSTANCE = new Multithreading();
    @NotNull
    private static final AtomicInteger counter = new AtomicInteger(0);
    @NotNull
    private static final ScheduledExecutorService scheduledPool;
    @NotNull
    private static ThreadPoolExecutor POOL;

    private Multithreading() {
    }

    @NotNull
    public static final ScheduledExecutorService getScheduledPool() {
        return scheduledPool;
    }

    @JvmStatic
    public static /* synthetic */ void getScheduledPool$annotations() {
    }

    @NotNull
    public static final ThreadPoolExecutor getPool() {
        return POOL;
    }

    @JvmStatic
    public static /* synthetic */ void getPool$annotations() {
    }

    @NotNull
    public final ThreadPoolExecutor getPOOL() {
        return POOL;
    }

    public final void setPOOL(@NotNull ThreadPoolExecutor threadPoolExecutor) {
        Intrinsics.checkNotNullParameter(threadPoolExecutor, "<set-?>");
        POOL = threadPoolExecutor;
    }

    @NotNull
    public final ScheduledFuture<?> schedule(@NotNull Runnable r, long initialDelay, long delay2, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter(r, "r");
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        ScheduledFuture<?> scheduledFuture = scheduledPool.scheduleAtFixedRate(r, initialDelay, delay2, unit);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, "scheduledPool.scheduleAt\u2026nitialDelay, delay, unit)");
        return scheduledFuture;
    }

    @JvmStatic
    @NotNull
    public static final ScheduledFuture<?> schedule(@NotNull Runnable r, long delay2, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter(r, "r");
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        ScheduledFuture<?> scheduledFuture = scheduledPool.schedule(r, delay2, unit);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, "scheduledPool.schedule(r, delay, unit)");
        return scheduledFuture;
    }

    @JvmStatic
    public static final void runAsync(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        POOL.execute(runnable);
    }

    @NotNull
    public final Future<?> submit(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        Future<?> future2 = POOL.submit(runnable);
        Intrinsics.checkNotNullExpressionValue(future2, "POOL.submit(runnable)");
        return future2;
    }

    private static final Thread scheduledPool$lambda-0(Runnable target) {
        return new Thread(target, "Essential Thread " + counter.incrementAndGet());
    }

    private static final Thread POOL$lambda-1(Runnable target) {
        String string = "Essential %s";
        Object[] objectArray = new Object[]{counter.incrementAndGet()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(format, *args)");
        return new Thread(target, string2);
    }

    static {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(10, Multithreading::scheduledPool$lambda-0);
        Intrinsics.checkNotNullExpressionValue(scheduledExecutorService, "newScheduledThreadPool(1\u2026.incrementAndGet())\n    }");
        scheduledPool = scheduledExecutorService;
        POOL = new ThreadPoolExecutor(10, 30, 0L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue(), Multithreading::POOL$lambda-1);
    }
}

