/*
 * Decompiled with CFR 0.152.
 */
package gg.essential;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import gg.essential.api.DI;
import gg.essential.api.EssentialAPI;
import gg.essential.api.commands.CommandRegistry;
import gg.essential.api.config.EssentialConfig;
import gg.essential.api.data.OnboardingData;
import gg.essential.api.gui.EssentialComponentFactory;
import gg.essential.api.utils.ShutdownHookUtil;
import gg.essential.api.utils.TrustedHostsUtil;
import gg.essential.api.utils.mojang.MojangAPI;
import gg.essential.commands.EssentialCommandRegistry;
import gg.essential.compatibility.vanilla.difficulty.Net;
import gg.essential.cosmetics.PlayerWearableManager;
import gg.essential.cosmetics.events.AnimationEffectHandler;
import gg.essential.elementa.components.image.FileImageCache;
import gg.essential.elementa.components.image.ImageCache;
import gg.essential.elementa.effects.StencilEffect;
import gg.essential.event.EventHandler;
import gg.essential.event.client.InitializationEvent;
import gg.essential.event.essential.TosAcceptedEvent;
import gg.essential.gui.GuiIngameMenuEditor;
import gg.essential.gui.GuiOptionsEditor;
import gg.essential.gui.account.factory.ActiveSessionFactory;
import gg.essential.gui.account.factory.InitialSessionFactory;
import gg.essential.gui.account.factory.MicrosoftAccountSessionFactory;
import gg.essential.gui.account.factory.MojangAccountSessionFactory;
import gg.essential.gui.account.factory.SessionFactory;
import gg.essential.gui.api.ComponentFactory;
import gg.essential.gui.notification.Notifications;
import gg.essential.gui.studio.CosmeticStudio;
import gg.essential.handlers.EssentialSkinManager;
import gg.essential.handlers.GameProfileManager;
import gg.essential.handlers.NetworkHook;
import gg.essential.handlers.NetworkSubscriptionStateHandler;
import gg.essential.handlers.PauseMenuDisplay;
import gg.essential.handlers.ReAuthChecker;
import gg.essential.handlers.ServerStatusHandler;
import gg.essential.handlers.ShutdownHook;
import gg.essential.handlers.WindowedFullscreenHandler;
import gg.essential.handlers.ZoomHandler;
import gg.essential.key.EssentialKeybindingRegistry;
import gg.essential.lib.kbrewster.eventbus.EventBus;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.lib.kbrewster.eventbus.invokers.InvokerType;
import gg.essential.lib.kbrewster.eventbus.invokers.LMFInvoker;
import gg.essential.lib.kbrewster.eventbus.invokers.ReflectionInvoker;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.universal.UMinecraft;
import gg.essential.util.GuiUtil;
import gg.essential.util.MinecraftUtils;
import gg.essential.util.Multithreading;
import gg.essential.util.OptiFineUtil;
import gg.essential.util.Sk1erModUtils;
import gg.essential.util.crash.StacktraceDeobfuscator;
import gg.essential.util.swing.SwingUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.jetbrains.annotations.NotNull;

public class Essential
implements EssentialAPI {
    public static final String MODID = "essential";
    public static final String NAME = "Essential";
    public static final String VERSION = "1.0.0";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Logger logger = LogManager.getLogger((String)"Essential Logger");
    public static final Logger debug = LogManager.getLogger((String)"Essential Logger - Debug");
    private static final InvokerType invoker = Essential.determineBestInvokerType();
    public static final EventBus EVENT_BUS = new EventBus(invoker, e -> {
        logger.error("Error occurred in method: {}", (Object)e.getMessage());
        e.printStackTrace();
    });
    private static Essential instance;
    private static boolean initialized;
    @NotNull
    private final ConnectionManager connectionManager = new ConnectionManager(new NetworkHook());
    private final List<SessionFactory> sessionFactories = new ArrayList<SessionFactory>();
    @NotNull
    private final EssentialKeybindingRegistry keybindingRegistry = new EssentialKeybindingRegistry();
    private ImageCache imageCache;
    private File baseDir = null;
    private PlayerWearableManager playerWearableManager;
    private final GameProfileManager gameProfileManager = new GameProfileManager();
    private final EssentialSkinManager skinManager = new EssentialSkinManager(this.gameProfileManager, () -> CosmeticStudio.getInstance() != null);
    private AnimationEffectHandler animationEffectHandler;

    public static Essential getInstance() {
        if (instance == null) {
            instance = new Essential();
        }
        return instance;
    }

    @NotNull
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @NotNull
    public EssentialKeybindingRegistry getKeybindingRegistry() {
        return this.keybindingRegistry;
    }

    @Subscribe
    public void initialize(InitializationEvent event) {
        if (initialized) {
            return;
        }
        initialized = true;
        gg.essential.DI.INSTANCE.startDI();
        this.baseDir = new File(UMinecraft.getMinecraft().field_1697, MODID);
        if (!this.baseDir.exists()) {
            this.baseDir.mkdirs();
        }
        this.init();
    }

    public void registerListener(Object o) {
        EVENT_BUS.register(o);
    }

    public GameProfileManager getGameProfileManager() {
        return this.gameProfileManager;
    }

    public EssentialSkinManager getSkinManager() {
        return this.skinManager;
    }

    private void init() {
        try {
            if (Sk1erModUtils.isOldModCorePresent() && gg.essential.config.EssentialConfig.INSTANCE.getModCoreWarning()) {
                logger.error("Old ModCore has been found!! Uh oh!");
                SwingUtil.showOldModCorePopup();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.sessionFactories.add(new MicrosoftAccountSessionFactory(this.baseDir.toPath().resolve("microsoft_accounts.json")));
            this.sessionFactories.add(new MojangAccountSessionFactory(this.baseDir.toPath().resolve("mojang_accounts.json")));
            this.sessionFactories.add(new ActiveSessionFactory());
            this.sessionFactories.add(new InitialSessionFactory());
        }
        catch (Exception e) {
            logger.error("Failed to load accounts:", (Throwable)e);
        }
        EventHandler.init();
        StencilEffect.Companion.enableStencil();
        gg.essential.config.EssentialConfig.INSTANCE.preload();
        this.imageCache = new FileImageCache(new File(this.getBaseDir(), "image-cache"), 1L, TimeUnit.HOURS, true);
        EVENT_BUS.register(EssentialCommandRegistry.INSTANCE);
        this.keybindingRegistry.refreshBinds();
        this.registerListener(this.keybindingRegistry);
        this.registerListener(new NetworkSubscriptionStateHandler());
        this.registerListener(MinecraftUtils.INSTANCE);
        this.registerListener(new ServerStatusHandler());
        this.registerListener(GuiUtil.INSTANCE);
        this.registerListener(new PauseMenuDisplay());
        this.registerListener(new GuiIngameMenuEditor());
        this.registerListener(new GuiOptionsEditor());
        this.registerListener(this.connectionManager);
        this.registerListener(new WindowedFullscreenHandler());
        this.registerListener(this.connectionManager.getSpsManager());
        this.animationEffectHandler = new AnimationEffectHandler();
        this.registerListener(this.animationEffectHandler);
        this.playerWearableManager = new PlayerWearableManager(this.connectionManager.getCosmeticsManager());
        this.registerListener(this.playerWearableManager);
        if (!OptiFineUtil.isLoaded()) {
            this.registerListener(ZoomHandler.getInstance());
        }
        this.connectionManager.getSubscriptionManager().addListener(this.gameProfileManager);
        Multithreading.runAsync(() -> {
            if (!gg.essential.data.OnboardingData.hasAcceptedTos()) {
                return;
            }
            logger.info("Connecting to Essential Connection Manager...");
            try {
                this.connectionManager.connect();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        });
        Net.INSTANCE.init();
        if (this.wasNoraHere()) {
            String newTitle = "Minecraft " + UMinecraft.getMinecraft().method_1515() + " (" + UMinecraft.getMinecraft().method_1548().method_1676() + ")";
            UMinecraft.getMinecraft().method_22683().method_24286(newTitle);
        }
        this.registerListener(Notifications.INSTANCE);
        this.registerListener(new ReAuthChecker());
        if (gg.essential.data.OnboardingData.hasAcceptedTos()) {
            EVENT_BUS.post(new TosAcceptedEvent());
        }
    }

    private void createStacktraceDeobfuscator() {
        File mappings;
        File mappingsFolder = new File(this.baseDir, "mappings");
        if (!mappingsFolder.exists()) {
            mappingsFolder.mkdir();
        }
        logger.info(((mappings = new File(mappingsFolder, "mappings-39-1.12.csv")).exists() ? "Found MCP method mappings: " : "Downloading MCP method mappings to: ") + mappings.getName());
        StacktraceDeobfuscator.setup(mappings);
    }

    private static InvokerType determineBestInvokerType() {
        if (System.getProperty("java.vm.name", "").contains("OpenJ9")) {
            return new ReflectionInvoker();
        }
        Object dummy = new Object(){

            public void dummy(Object obj) {
            }
        };
        try {
            LMFInvoker lmfInvoker = new LMFInvoker();
            lmfInvoker.setup(dummy, dummy.getClass(), Object.class, dummy.getClass().getMethod("dummy", Object.class));
            return lmfInvoker;
        }
        catch (Throwable e) {
            logger.error("Could not set up LMFInvoker: ", e);
            return new ReflectionInvoker();
        }
    }

    public void debugKeyFunction() {
    }

    public boolean wasNoraHere() {
        return System.getProperty("essential.noraWasHere", "false").equals("true");
    }

    public List<SessionFactory> getSessionFactories() {
        return this.sessionFactories;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    @Override
    @NotNull
    public CommandRegistry commandRegistry() {
        return EssentialCommandRegistry.INSTANCE;
    }

    @Override
    @NotNull
    public DI di() {
        return gg.essential.DI.INSTANCE;
    }

    @Override
    @NotNull
    public gg.essential.api.gui.Notifications notifications() {
        return Notifications.INSTANCE;
    }

    @Override
    @NotNull
    public EssentialConfig config() {
        return gg.essential.config.EssentialConfig.INSTANCE;
    }

    @Override
    @NotNull
    public gg.essential.api.utils.GuiUtil guiUtil() {
        return GuiUtil.INSTANCE;
    }

    @Override
    @NotNull
    public gg.essential.api.utils.MinecraftUtils minecraftUtil() {
        return MinecraftUtils.INSTANCE;
    }

    @Override
    @NotNull
    public ShutdownHookUtil shutdownHookUtil() {
        return ShutdownHook.INSTANCE;
    }

    @Override
    @NotNull
    public ImageCache imageCache() {
        return this.imageCache;
    }

    @Override
    @NotNull
    public TrustedHostsUtil trustedHostsUtil() {
        return gg.essential.util.TrustedHostsUtil.INSTANCE;
    }

    @Override
    @NotNull
    public EssentialComponentFactory componentFactory() {
        return ComponentFactory.INSTANCE;
    }

    @Override
    @NotNull
    public MojangAPI mojangAPI() {
        return gg.essential.util.MojangAPI.INSTANCE;
    }

    @Override
    @NotNull
    public OnboardingData onboardingData() {
        return gg.essential.data.OnboardingData.INSTANCE;
    }

    public PlayerWearableManager getPlayerWearableManager() {
        return this.playerWearableManager;
    }

    public AnimationEffectHandler getAnimationEffectHandler() {
        return this.animationEffectHandler;
    }

    static {
        initialized = false;
        if (MinecraftUtils.INSTANCE.isDevelopment()) {
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration conf = ctx.getConfiguration();
            conf.getLoggerConfig("Essential Logger - Debug").setLevel(Level.ALL);
            ctx.updateLoggers(conf);
        }
    }
}

