/*
 * Decompiled with CFR 0.152.
 */
package com.sparkuniverse.toolbox.util;

import com.sparkuniverse.toolbox.util.Validate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class DateTime
extends Date {
    private static final Pattern TIME_STRING_REGEX = Pattern.compile("(\\d+)([A-Za-z]+)");
    public static final SimpleDateFormat DEFAULT_FORMAT = new SimpleDateFormat("yyy-MM-dd @ HH:mm:ss");

    @Deprecated
    public static DateTime fromDate(@NotNull Date date) {
        Validate.notNull(date);
        return new DateTime(date.getTime());
    }

    public DateTime() {
        this(Calendar.getInstance().getTimeInMillis());
    }

    public DateTime(long millis) {
        super(millis);
    }

    public DateTime(String dateString) throws ParseException {
        this(dateString, DEFAULT_FORMAT);
    }

    public DateTime(@NotNull String dateString, @NotNull SimpleDateFormat format) throws ParseException {
        super(format.parse(dateString).getTime());
    }

    public DateTime add(@NotNull String timeToAdd) throws ParseException {
        Validate.notNull(timeToAdd, () -> "timeToAdd must not be null", new Object[0]);
        if (timeToAdd.length() < 2) {
            throw new ParseException("Invalid input: too short", 0);
        }
        if (timeToAdd.startsWith("-")) {
            throw new ParseException("Invalid input: cannot be negative", 0);
        }
        Matcher matcher = TIME_STRING_REGEX.matcher(timeToAdd);
        if (!matcher.matches()) {
            throw new ParseException("Invalid input: cannot parse amount and unit", 0);
        }
        String amountString = matcher.group(1);
        String unit = matcher.group(2);
        int amount = Integer.parseInt(amountString);
        switch (unit) {
            case "y": {
                return this.add(TimeUnit.DAYS, amount * 356);
            }
            case "m": {
                return this.add(TimeUnit.DAYS, amount * 28);
            }
            case "w": {
                return this.add(TimeUnit.DAYS, amount * 7);
            }
            case "d": {
                return this.add(TimeUnit.DAYS, amount);
            }
            case "h": {
                return this.add(TimeUnit.HOURS, amount);
            }
            case "mins": 
            case "min": {
                return this.add(TimeUnit.MINUTES, amount);
            }
            case "s": {
                return this.add(TimeUnit.SECONDS, amount);
            }
        }
        throw new ParseException("Invalid input: unknown unit " + unit, 0);
    }

    public DateTime add(@NotNull TimeUnit unit, int amount) {
        return this.add(unit.toMillis(amount));
    }

    public DateTime add(@NotNull Duration duration) {
        return this.add(duration.toMillis());
    }

    public DateTime add(long milliseconds) {
        this.setTime(this.getTime() + milliseconds);
        return this;
    }

    public String format() {
        return this.format(DEFAULT_FORMAT);
    }

    public String format(@NotNull SimpleDateFormat format) {
        return format.format(this);
    }
}

