/*
 * Decompiled with CFR 0.152.
 */
package com.sparkuniverse.toolbox.serialization;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumTypeAdapter<T extends Enum>
extends TypeAdapter<T> {
    @NotNull
    private static Map<Class<? extends Enum>, EnumTypeAdapter<?>> ADAPTERS = new ConcurrentHashMap();
    @NotNull
    private final Class<T> enumClazz;

    @NotNull
    public static <T extends Enum> EnumTypeAdapter<T> of(@NotNull Class<T> clazz) {
        return ADAPTERS.computeIfAbsent(clazz, __ -> new EnumTypeAdapter(clazz));
    }

    EnumTypeAdapter(@NotNull Class<T> clazz) {
        this.enumClazz = clazz;
    }

    public void write(@NotNull JsonWriter writer, @Nullable T value2) throws IOException {
        if (value2 == null) {
            writer.nullValue();
            return;
        }
        writer.value(((Enum)value2).toString());
    }

    public T read(@NotNull JsonReader reader) throws IOException {
        if (JsonToken.NULL == reader.peek()) {
            return null;
        }
        String value2 = reader.nextString();
        if (value2 == null || value2.isEmpty()) {
            return null;
        }
        try {
            return Enum.valueOf(this.enumClazz, value2);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return null;
        }
    }
}

