/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2.restart;

import gg.essential.loader.stage2.components.EssentialStyle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.text.View;

public class NeedsRestartUI
implements EssentialStyle {
    private static final int FRAME_WIDTH = 269;
    private static final int TEXT_HEIGHT = 74;
    private final CompletableFuture<?> closedFuture = new CompletableFuture();
    private final JFrame frame = this.makeFrame(it -> this.closedFuture.complete(null));
    private final List<String> updatedModNames;

    public NeedsRestartUI(List<String> updatedModNames) {
        this.updatedModNames = updatedModNames;
    }

    public void show() {
        ArrayList<JLabel> htmlLabels = new ArrayList<JLabel>();
        JPanel content = this.makeContentWithLogo(this.frame);
        content.setMinimumSize(new Dimension(269, 0));
        content.setMaximumSize(new Dimension(269, Integer.MAX_VALUE));
        content.setBorder(new EmptyBorder(0, 26, 0, 26));
        JLabel explanation = new JLabel("<html>You have to <font color=white>restart the game to continue</font>. Updates from the following mods require a manual restart:</html>", 2);
        explanation.setMaximumSize(new Dimension(269, Integer.MAX_VALUE));
        explanation.setForeground(COLOR_FOREGROUND);
        explanation.setAlignmentX(0.5f);
        if (EssentialStyle.Fonts.medium != null) {
            explanation.setFont(EssentialStyle.Fonts.medium.deriveFont(15.0f));
        }
        content.add(explanation);
        htmlLabels.add(explanation);
        content.add(Box.createVerticalStrut(20));
        JPanel modList = new JPanel();
        modList.setMaximumSize(new Dimension(269, Integer.MAX_VALUE));
        modList.setBackground(COLOR_BACKGROUND);
        modList.setLayout(new BoxLayout(modList, 1));
        content.add(modList);
        for (String modName : this.updatedModNames) {
            JPanel modPanel = new JPanel();
            modPanel.setLayout(new BorderLayout());
            modPanel.setBackground(COLOR_BACKGROUND);
            modList.add(modPanel);
            JPanel bulletContainer = new JPanel();
            bulletContainer.setLayout(new BoxLayout(bulletContainer, 0));
            bulletContainer.setBackground(COLOR_BACKGROUND);
            modPanel.add((Component)bulletContainer, "Before");
            JComponent bullet = new JComponent(){

                @Override
                public boolean isOpaque() {
                    return false;
                }

                @Override
                protected void paintComponent(Graphics g) {
                    Graphics graphics = g.create();
                    if (graphics instanceof Graphics2D) {
                        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    }
                    graphics.setColor(this.getForeground());
                    graphics.fillOval(0, 7, 4, 4);
                }
            };
            bullet.setMinimumSize(new Dimension(4, 15));
            bullet.setPreferredSize(new Dimension(4, 15));
            bullet.setMaximumSize(new Dimension(4, 15));
            bullet.setForeground(Color.WHITE);
            bullet.setAlignmentY(0.0f);
            bulletContainer.add(Box.createHorizontalStrut(8));
            bulletContainer.add(bullet);
            bulletContainer.add(Box.createHorizontalStrut(8));
            JLabel text = new JLabel("<html>" + modName + "</html>", 2);
            text.setForeground(Color.WHITE);
            text.setAlignmentX(0.0f);
            if (EssentialStyle.Fonts.medium != null) {
                text.setFont(EssentialStyle.Fonts.medium.deriveFont(15.0f));
            }
            modPanel.add(text);
            htmlLabels.add(text);
        }
        content.add(Box.createVerticalStrut(26));
        JButton close = new JButton("Quit Game");
        close.setBorder(BorderFactory.createEmptyBorder(8, 13, 8, 13));
        close.setFocusPainted(false);
        close.setContentAreaFilled(false);
        close.setForeground(Color.WHITE);
        if (EssentialStyle.Fonts.semiBold != null) {
            close.setFont(EssentialStyle.Fonts.semiBold.deriveFont(15.0f));
        }
        close.addActionListener(e -> this.closedFuture.complete(null));
        JPanel closeContainer = new JPanel();
        closeContainer.setLayout(new BoxLayout(closeContainer, 0));
        closeContainer.setAlignmentX(0.5f);
        closeContainer.setBackground(COLOR_BUTTON);
        close.getModel().addChangeListener(e -> closeContainer.setBackground(close.getModel().isRollover() ? COLOR_BUTTON_HOVER : COLOR_BUTTON));
        closeContainer.add(close);
        content.add(closeContainer);
        content.add(Box.createVerticalStrut(20));
        this.frame.pack();
        htmlLabels.forEach(this::fixJLabelHeight);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void fixJLabelHeight(JLabel label) {
        View view = (View)label.getClientProperty("html");
        view.setSize(label.getWidth(), 0.0f);
        label.setSize((int)view.getPreferredSpan(0), (int)view.getPreferredSpan(1));
    }

    public void waitForClose() {
        this.closedFuture.join();
        this.close();
    }

    public void close() {
        this.frame.dispose();
    }

    public static void main(String[] args) {
        List<String> mods = Arrays.asList("Fabric Language Kotlin", "Elementa", "Example Mod With Unreasonably Long Name", "Vigilance");
        NeedsRestartUI ui = new NeedsRestartUI(mods);
        ui.show();
        ui.waitForClose();
    }
}

