/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2.restart;

import gg.essential.loader.stage2.jvm.ForkedJvm;
import gg.essential.loader.stage2.restart.NeedsRestartUI;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForkedNeedsRestartUI {
    private final Logger LOGGER = LogManager.getLogger();
    private final List<String> updatedModNames;
    private final List<Path> modsToDisable;
    private ForkedJvm jvm;

    public ForkedNeedsRestartUI(List<String> updatedModNames, List<Path> modsToDisable) {
        this.updatedModNames = updatedModNames;
        this.modsToDisable = modsToDisable;
    }

    public void show() {
        try {
            this.jvm = new ForkedJvm(this.getClass());
            DataOutputStream out = new DataOutputStream(this.jvm.process.getOutputStream());
            for (String name : this.updatedModNames) {
                out.writeBoolean(true);
                out.writeUTF(name);
            }
            out.writeBoolean(false);
            for (Path path : this.modsToDisable) {
                out.writeBoolean(true);
                out.writeUTF(path.toAbsolutePath().toString());
            }
            out.writeBoolean(false);
            out.writeBoolean(Boolean.getBoolean("essential.integration_testing"));
            out.flush();
        }
        catch (IOException e) {
            this.LOGGER.warn("Failed to fork JVM for NeedsRestartUI:", (Throwable)e);
        }
    }

    public void waitForClose() {
        if (this.jvm == null) {
            return;
        }
        try {
            this.jvm.process.getInputStream().read();
        }
        catch (IOException e) {
            this.LOGGER.warn("Failed to wait for NeedsRestartUI to close:", (Throwable)e);
            this.jvm.close();
        }
    }

    public void exit() {
        if (this.jvm != null) {
            try {
                this.jvm.process.getOutputStream().close();
            }
            catch (IOException e) {
                this.LOGGER.warn("Failed to signal exit to forked NeedsRestartUI JVM:", (Throwable)e);
                this.jvm.close();
                this.jvm = null;
            }
        }
        if (this.jvm != null && Boolean.getBoolean("essential.integration_testing")) {
            try {
                this.jvm.process.waitFor(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        DataInputStream in = new DataInputStream(System.in);
        ArrayList<String> updatedModNames = new ArrayList<String>();
        while (in.readBoolean()) {
            updatedModNames.add(in.readUTF());
        }
        ArrayList<Path> modsToDisable = new ArrayList<Path>();
        while (in.readBoolean()) {
            modsToDisable.add(Paths.get(in.readUTF(), new String[0]));
        }
        boolean isIntegrationTest = in.readBoolean();
        try {
            NeedsRestartUI ui = new NeedsRestartUI(updatedModNames);
            ui.show();
            if (isIntegrationTest) {
                ui.close();
            } else {
                ui.waitForClose();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.out.write(0);
        System.out.flush();
        in.read();
        ForkedNeedsRestartUI.disableMods(modsToDisable);
    }

    private static void disableMods(List<Path> modsToDisable) {
        boolean interrupted = false;
        block4: for (Path path : modsToDisable) {
            int attempt = 0;
            while (true) {
                try {
                    Files.move(path, path.resolveSibling(path.getFileName() + ".disabled"), new CopyOption[0]);
                }
                catch (IOException ioException) {
                    if (attempt++ < 100) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            interrupted = true;
                            continue block4;
                        }
                        continue;
                    }
                    ioException.printStackTrace();
                }
                break;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

