/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2.data;

import gg.essential.loader.stage2.data.ModId;
import gg.essential.loader.stage2.data.ModVersion;
import gg.essential.loader.stage2.util.Checksum;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;

public class ModJarMetadata {
    public static final ModJarMetadata EMPTY = new ModJarMetadata(ModId.UNKNOWN, ModVersion.UNKNOWN, null, null);
    @NotNull
    private final ModId mod;
    @NotNull
    private final ModVersion version;
    private final String platform;
    private final String checksum;

    public ModJarMetadata(@NotNull ModId mod, @NotNull ModVersion version, String platform, String checksum) {
        this.mod = mod;
        this.version = version;
        this.platform = platform;
        this.checksum = checksum;
    }

    @NotNull
    public ModId getMod() {
        return this.mod;
    }

    @NotNull
    public ModVersion getVersion() {
        return this.version;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModJarMetadata that = (ModJarMetadata)o;
        return this.mod.equals(that.mod) && this.version.equals(that.version) && Objects.equals(this.platform, that.platform) && Objects.equals(this.checksum, that.checksum);
    }

    public int hashCode() {
        return Objects.hash(this.mod, this.version, this.platform, this.checksum);
    }

    public void write(Path jarFile) throws IOException {
        try (FileSystem fileSystem = FileSystems.newFileSystem(jarFile, (ClassLoader)null);){
            Throwable throwable;
            Path manifestPath = fileSystem.getPath("META-INF", "MANIFEST.MF");
            Manifest manifest = new Manifest();
            if (Files.exists(manifestPath, new LinkOption[0])) {
                throwable = null;
                try (InputStream in = Files.newInputStream(manifestPath, new OpenOption[0]);){
                    manifest.read(in);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            this.write(manifest.getMainAttributes());
            throwable = null;
            try (OutputStream out = Files.newOutputStream(manifestPath, StandardOpenOption.CREATE);){
                manifest.write(out);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
    }

    public void write(Attributes attributes) {
        ModJarMetadata.put(attributes, "Essential-Mod-Publisher-Id", this.mod.getPublisherId());
        ModJarMetadata.put(attributes, "Essential-Mod-Publisher-Slug", this.mod.getPublisherSlug());
        ModJarMetadata.put(attributes, "Essential-Mod-Id", this.mod.getModId());
        ModJarMetadata.put(attributes, "Essential-Mod-Slug", this.mod.getModSlug());
        ModJarMetadata.put(attributes, "Essential-Mod-Version-Id", this.version.getId());
        ModJarMetadata.put(attributes, "Essential-Mod-Version", this.version.getVersion());
        ModJarMetadata.put(attributes, "Essential-Mod-Platform", this.platform);
        ModJarMetadata.put(attributes, "Essential-Mod-Checksum", this.checksum);
    }

    private static void put(Attributes attributes, String key, String value) {
        if (value != null) {
            attributes.putValue(key, value);
        }
    }

    public static ModJarMetadata read(Attributes attributes) {
        return new ModJarMetadata(new ModId(attributes.getValue("Essential-Mod-Publisher-Id"), attributes.getValue("Essential-Mod-Publisher-Slug"), attributes.getValue("Essential-Mod-Id"), attributes.getValue("Essential-Mod-Slug")), new ModVersion(attributes.getValue("Essential-Mod-Version-Id"), attributes.getValue("Essential-Mod-Version")), attributes.getValue("Essential-Mod-Platform"), attributes.getValue("Essential-Mod-Checksum"));
    }

    public static ModJarMetadata read(Path jarFile) throws IOException {
        ModJarMetadata metadata;
        block25: {
            metadata = EMPTY;
            try (FileSystem fileSystem = FileSystems.newFileSystem(jarFile, (ClassLoader)null);){
                Path manifestPath = fileSystem.getPath("META-INF", "MANIFEST.MF");
                if (!Files.exists(manifestPath, new LinkOption[0])) break block25;
                try (InputStream in = Files.newInputStream(manifestPath, new OpenOption[0]);){
                    metadata = ModJarMetadata.read(new Manifest(in).getMainAttributes());
                }
            }
        }
        if (metadata.getChecksum() == null) {
            String checksum = Checksum.getChecksum(jarFile);
            metadata = new ModJarMetadata(metadata.mod, metadata.version, metadata.platform, checksum);
        }
        return metadata;
    }
}

