/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2.components;

import gg.essential.loader.stage2.components.MotionFrame;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;

public interface EssentialStyle {
    public static final Color COLOR_BACKGROUND = new Color(9, 16, 11);
    public static final Color COLOR_FOREGROUND = new Color(172, 172, 172);
    public static final Color COLOR_OUTLINE = new Color(64, 64, 64);
    public static final Color COLOR_PROGRESS_FILL = new Color(43, 197, 83);
    public static final Color COLOR_BUTTON = new Color(102, 102, 102);
    public static final Color COLOR_BUTTON_HOVER = COLOR_PROGRESS_FILL;

    default public JFrame makeFrame(final Consumer<JFrame> onExit) {
        try {
            UIManager.setLookAndFeel(NimbusLookAndFeel.class.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        final JFrame frame = new JFrame();
        frame.setTitle("Updating Essential...");
        try {
            frame.setIconImage(ImageIO.read(Objects.requireNonNull(this.getClass().getResource("/assets/essential-loader-stage2/icon.png"))));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        frame.setUndecorated(true);
        frame.setResizable(false);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                onExit.accept(frame);
            }
        });
        MotionFrame.addMotion(frame);
        Container container = frame.getContentPane();
        container.setBackground(COLOR_BACKGROUND);
        container.setLayout(null);
        return frame;
    }

    default public JPanel makeContentWithLogo(JFrame frame) {
        JPanel contentPane = new JPanel();
        contentPane.setBackground(COLOR_BACKGROUND);
        contentPane.setLayout(new BoxLayout(contentPane, 3));
        frame.getContentPane().add(contentPane);
        frame.getContentPane().setLayout(new BoxLayout(frame.getContentPane(), 3));
        try {
            BufferedImage icon = ImageIO.read(Objects.requireNonNull(this.getClass().getResource("/assets/essential-loader-stage2/essential.png")));
            JLabel label = new JLabel(new ImageIcon(icon));
            label.setBorder(new EmptyBorder(28, 0, 28, 0));
            label.setAlignmentX(0.5f);
            contentPane.add(label);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contentPane;
    }

    public static class Fonts {
        public static final Font medium = Fonts.createFont("/assets/essential-loader-stage2/Gilroy-Medium.otf", 0);
        public static final Font semiBold = Fonts.createFont("/assets/essential-loader-stage2/Gilroy-SemiBold.otf", 0);

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static Font createFont(String path, int format) {
            try (InputStream stream = Fonts.class.getResourceAsStream(path);){
                Font font2 = Font.createFont(format, stream);
                GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font2);
                Font font = font2;
                return font;
            }
            catch (FontFormatException | IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

