/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import gg.essential.loader.stage2.LoaderLoggingUI;
import gg.essential.loader.stage2.LoaderSwingUI;
import gg.essential.loader.stage2.LoaderUI;
import gg.essential.loader.stage2.Utils;
import gg.essential.loader.stage2.data.ModId;
import gg.essential.loader.stage2.data.ModJarMetadata;
import gg.essential.loader.stage2.data.ModVersion;
import gg.essential.loader.stage2.diff.DiffPatcher;
import gg.essential.loader.stage2.jvm.ForkedJvmLoaderSwingUI;
import gg.essential.loader.stage2.util.Checksum;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class EssentialLoaderBase {
    private static final Logger LOGGER = LogManager.getLogger(EssentialLoaderBase.class);
    private static final String BASE_URL = System.getProperty("essential.download.url", System.getenv().getOrDefault("ESSENTIAL_DOWNLOAD_URL", "https://api.essential.gg/mods"));
    private static final String DEFAULT_BRANCH = "stable";
    private static final String VERSION_BASE_URL = BASE_URL + "/v1/essential:essential/versions/%s";
    private static final String VERSION_URL = VERSION_BASE_URL + "/platforms/%s";
    private static final String DOWNLOAD_URL = VERSION_URL + "/download";
    private static final String DIFF_URL = VERSION_BASE_URL + "/diff/%s/platforms/%s";
    protected static final String CLASS_NAME = "gg.essential.api.tweaker.EssentialTweaker";
    private static final String FILE_BASE_NAME = "Essential (%s)";
    private static final String FILE_EXTENSION = "jar";
    private static final boolean AUTO_UPDATE = "true".equals(System.getProperty("essential.autoUpdate", "true"));
    private final Path gameDir;
    private final String gameVersion;
    private final String apiGameVersion;
    private final String fileBaseName;
    private final LoaderUI ui;

    public EssentialLoaderBase(Path gameDir, String gameVersion, boolean lwjgl3) {
        this.gameDir = gameDir;
        this.gameVersion = gameVersion;
        this.apiGameVersion = gameVersion.replace(".", "-");
        this.fileBaseName = String.format(FILE_BASE_NAME, this.gameVersion);
        String stage2Branch = System.getProperty("essential.stage2.branch", System.getenv().getOrDefault("ESSENTIAL_STAGE2_BRANCH", DEFAULT_BRANCH));
        if (!stage2Branch.equals(DEFAULT_BRANCH)) {
            LOGGER.info("Essential Loader (stage2) branch set to \"{}\".", new Object[]{stage2Branch});
        }
        String os = System.getProperty("os.name", "").toLowerCase(Locale.ROOT);
        LoaderUI gui = lwjgl3 && (os.contains("mac") || os.contains("darwin")) ? new ForkedJvmLoaderSwingUI() : new LoaderSwingUI();
        this.ui = LoaderUI.all(new LoaderLoggingUI().updatesEveryMillis(1000), gui.updatesEveryMillis(16));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        String currentChecksum;
        Path dataDir = this.gameDir.resolve("essential").toRealPath(new LinkOption[0]);
        if (Files.notExists(dataDir, new LinkOption[0])) {
            Files.createDirectories(dataDir, new FileAttribute[0]);
        }
        if (this.isInClassPath()) {
            if (!Boolean.getBoolean("essential.loader.relaunched")) {
                LOGGER.warn("Essential loaded as a regular mod. No automatic updates will be applied.");
            }
            this.loadPlatform();
            return;
        }
        Path essentialFile = (Path)Utils.findMostRecentFile(dataDir, this.fileBaseName, FILE_EXTENSION).getKey();
        boolean needUpdate = false;
        ModJarMetadata currentMeta = ModJarMetadata.EMPTY;
        if (Files.exists(essentialFile, new LinkOption[0])) {
            currentMeta = ModJarMetadata.read(essentialFile);
        }
        if ((currentChecksum = currentMeta.getChecksum()) == null) {
            needUpdate = true;
        }
        String branch = this.determineBranch();
        ModJarMetadata latestMeta = null;
        if ((needUpdate || AUTO_UPDATE) && (latestMeta = this.fetchLatestVersion(ModId.ESSENTIAL, branch)) == null && needUpdate) {
            return;
        }
        if (!needUpdate && latestMeta != null && !latestMeta.getChecksum().equals(currentChecksum)) {
            needUpdate = true;
        }
        if (needUpdate) {
            Path downloadedFile;
            this.ui.start();
            try {
                downloadedFile = this.update(essentialFile, currentMeta, latestMeta);
            }
            finally {
                this.ui.complete();
            }
            if (downloadedFile != null) {
                latestMeta.write(downloadedFile);
                try {
                    Files.deleteIfExists(essentialFile);
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to delete old Essential file, will try again later.", (Throwable)e);
                }
                essentialFile = Utils.findNextMostRecentFile(dataDir, this.fileBaseName, FILE_EXTENSION);
                Files.move(downloadedFile, essentialFile, new CopyOption[0]);
                currentMeta = latestMeta;
            } else {
                LOGGER.warn("Unable to download Essential, please check your internet connection. If the problem persists, please contact Support.");
            }
        }
        if (!Files.exists(essentialFile, new LinkOption[0])) {
            return;
        }
        ModVersion version = currentMeta.getVersion();
        if (version.getVersion() != null) {
            System.setProperty("essential.version", version.getVersion());
        }
        this.addToClasspath(essentialFile, this.extractJarsInJar(essentialFile));
        if (this.classpathUpdatesImmediately() && !this.isInClassPath()) {
            throw new IllegalStateException("Could not find Essential in the classpath even though we added it without errors (fileExists=" + Files.exists(essentialFile, new LinkOption[0]) + ").");
        }
        this.loadPlatform();
    }

    private String determineBranch() {
        String DEFAULT_SOURCE = "default";
        List<Pair> configs = Arrays.asList(Pair.of((Object)"property", (Object)System.getProperty("essential.branch")), Pair.of((Object)"environment", (Object)System.getenv().get("ESSENTIAL_BRANCH")), Pair.of((Object)"file", (Object)this.determineBranchFromFile()), Pair.of((Object)"default", (Object)DEFAULT_BRANCH));
        String resultBranch = null;
        String resultSource = null;
        for (Pair config : configs) {
            String source = (String)config.getKey();
            String branch = (String)config.getValue();
            if (branch == null) {
                LOGGER.trace("Checked {} for Essential branch, was not supplied.", new Object[]{source});
                continue;
            }
            if (resultBranch != null) {
                if (source.equals("default")) continue;
                LOGGER.warn("Essential branch supplied via {} as \"{}\" but ignored because {} is more important.", new Object[]{source, branch, resultSource});
                continue;
            }
            Level level = source.equals("default") ? Level.DEBUG : Level.INFO;
            LOGGER.log(level, "Essential branch set to \"{}\" via {}.", new Object[]{branch, source});
            resultBranch = branch;
            resultSource = source;
        }
        assert (resultBranch != null);
        System.setProperty("essential.branch", resultBranch);
        return resultBranch;
    }

    private String determineBranchFromFile() {
        String BRANCH_FILE_NAME = "essential_branch.txt";
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("essential_branch.txt");
            if (!resources.hasMoreElements()) {
                return null;
            }
            URL url = resources.nextElement();
            String branch = IOUtils.toString((URL)url, (Charset)StandardCharsets.UTF_8).trim();
            LOGGER.info("Found {} for branch \"{}\".", new Object[]{url, branch});
            while (resources.hasMoreElements()) {
                LOGGER.warn("Found extra branch file, ignoring: {}", new Object[]{resources.nextElement()});
            }
            return branch;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to check for essential_branch.txt file on classpath:", (Throwable)e);
            return null;
        }
    }

    private Path update(Path essentialFile, ModJarMetadata currentMeta, ModJarMetadata latestMeta) throws IOException {
        Path updatedFile;
        if (!currentMeta.getVersion().isUnknown() && (updatedFile = this.updateViaDiff(essentialFile, currentMeta, latestMeta)) != null) {
            return updatedFile;
        }
        return this.updateViaDownload(latestMeta);
    }

    private Path updateViaDiff(Path essentialFile, ModJarMetadata currentMeta, ModJarMetadata latestMeta) throws IOException {
        FileMeta meta = this.fetchDiffUrl(latestMeta.getMod(), currentMeta.getVersion(), latestMeta.getVersion());
        if (meta == null) {
            return null;
        }
        Path downloadedFile = Files.createTempFile("essential-download-", "", new FileAttribute[0]);
        if (!this.downloadFile(meta.url, downloadedFile, meta.checksum)) {
            return null;
        }
        Path patchedFile = Files.createTempFile("essential-patched-", "", new FileAttribute[0]);
        Files.copy(essentialFile, patchedFile, StandardCopyOption.REPLACE_EXISTING);
        try {
            DiffPatcher.apply(patchedFile, downloadedFile);
            Files.delete(downloadedFile);
        }
        catch (Exception e) {
            LOGGER.error("Error while applying diff:", (Throwable)e);
            Files.deleteIfExists(patchedFile);
            Files.deleteIfExists(downloadedFile);
            return null;
        }
        return patchedFile;
    }

    private Path updateViaDownload(ModJarMetadata latestMeta) throws IOException {
        FileMeta meta = this.fetchDownloadUrl(latestMeta.getMod(), latestMeta.getVersion());
        if (meta == null) {
            return null;
        }
        Path downloadedFile = Files.createTempFile("essential-download-", "", new FileAttribute[0]);
        if (!this.downloadFile(meta.url, downloadedFile, meta.checksum)) {
            return null;
        }
        return downloadedFile;
    }

    private JsonObject fetchJsonObject(String endpoint, boolean allowEmpty) {
        URLConnection connection = null;
        try {
            String response;
            connection = this.prepareConnection(endpoint);
            try (InputStream inputStream = connection.getInputStream();){
                response = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
            }
            JsonElement jsonElement = new JsonParser().parse(response);
            if (!jsonElement.isJsonObject()) {
                if (allowEmpty && jsonElement.isJsonNull()) {
                    return new JsonObject();
                }
                throw new IOException("Excepted json object, got " + response);
            }
            return jsonElement.getAsJsonObject();
        }
        catch (JsonParseException | IOException e) {
            LOGGER.error("Error occurred fetching " + endpoint + ": ", e);
            this.logConnectionInfoOnError(connection);
            return null;
        }
    }

    private ModJarMetadata fetchLatestVersion(ModId modId, String branch) {
        String checksum;
        JsonObject responseObject = this.fetchJsonObject(String.format(VERSION_URL, branch, this.apiGameVersion), true);
        if (responseObject == null) {
            LOGGER.warn("Essential does not support the following game version: {}", new Object[]{this.gameVersion});
            return null;
        }
        JsonElement jsonId = responseObject.get("id");
        JsonElement jsonVersion = responseObject.get("version");
        JsonElement jsonChecksum = responseObject.get("checksum");
        String id = jsonId != null && jsonId.isJsonPrimitive() ? jsonId.getAsString() : null;
        String version = jsonVersion != null && jsonVersion.isJsonPrimitive() ? jsonVersion.getAsString() : null;
        String string = checksum = jsonChecksum != null && jsonChecksum.isJsonPrimitive() ? jsonChecksum.getAsString() : null;
        if (StringUtils.isEmpty((CharSequence)id) || StringUtils.isEmpty((CharSequence)version)) {
            LOGGER.warn("Unexpected response object data (id={}, version={}, checksum={})", new Object[]{jsonId, jsonVersion, jsonChecksum});
            return null;
        }
        return new ModJarMetadata(modId, new ModVersion(id, version), this.apiGameVersion, checksum);
    }

    private FileMeta fetchDownloadUrl(ModId modId, ModVersion modVersion) {
        return this.fetchFileMeta(String.format(DOWNLOAD_URL, modVersion.getVersion(), this.apiGameVersion));
    }

    private FileMeta fetchDiffUrl(ModId modId, ModVersion oldVersion, ModVersion modVersion) {
        return this.fetchFileMeta(String.format(DIFF_URL, oldVersion.getVersion(), modVersion.getVersion(), this.apiGameVersion));
    }

    private FileMeta fetchFileMeta(String endpoint) {
        String checksum;
        JsonObject responseObject = this.fetchJsonObject(endpoint, false);
        if (responseObject == null) {
            return null;
        }
        JsonElement jsonUrl = responseObject.get("url");
        JsonElement jsonChecksum = responseObject.get("checksum");
        String url = jsonUrl != null && jsonUrl.isJsonPrimitive() ? jsonUrl.getAsString() : null;
        String string = checksum = jsonChecksum != null && jsonChecksum.isJsonPrimitive() ? responseObject.get("checksum").getAsString() : null;
        if (StringUtils.isEmpty((CharSequence)url) || StringUtils.isEmpty((CharSequence)checksum)) {
            LOGGER.warn("Unexpected response object data (url={}, checksum={})", new Object[]{jsonUrl, jsonChecksum});
            return null;
        }
        return new FileMeta(url, checksum);
    }

    private URLConnection prepareConnection(String url) throws IOException {
        URLConnection urlConnection = new URL(url).openConnection();
        if (urlConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setUseCaches(true);
            httpURLConnection.setConnectTimeout(30000);
            httpURLConnection.setReadTimeout(30000);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.addRequestProperty("User-Agent", "Mozilla/5.0 (Essential Initializer)");
        }
        return urlConnection;
    }

    protected Path getExtractedJarsRoot() {
        return this.gameDir.resolve("essential").resolve("libraries").resolve(this.gameVersion);
    }

    private List<Path> extractJarsInJar(Path outerJar) throws IOException {
        Path extractedJarsRoot = this.getExtractedJarsRoot();
        Files.createDirectories(extractedJarsRoot, new FileAttribute[0]);
        ArrayList<Path> extractedJars = new ArrayList<Path>();
        try (FileSystem fileSystem = FileSystems.newFileSystem(outerJar, (ClassLoader)null);){
            List innerJars;
            Path innerJarsRoot = fileSystem.getPath("META-INF", "jars");
            if (!Files.isDirectory(innerJarsRoot, new LinkOption[0])) {
                ArrayList<Path> arrayList = extractedJars;
                return arrayList;
            }
            try (Stream<Path> stream = Files.list(innerJarsRoot);){
                innerJars = stream.collect(Collectors.toList());
            }
            for (Path innerJar : innerJars) {
                Path extractedJar = extractedJarsRoot.resolve(innerJar.getFileName().toString());
                if (Files.exists(extractedJar, new LinkOption[0])) {
                    LOGGER.debug("Already extracted: {}", new Object[]{innerJar});
                } else {
                    LOGGER.debug("Extracting {} to {}", new Object[]{innerJar, extractedJar});
                    Path tmpJar = Files.createTempFile(extractedJarsRoot, "tmp", ".jar", new FileAttribute[0]);
                    Files.copy(innerJar, tmpJar, StandardCopyOption.REPLACE_EXISTING);
                    Files.move(tmpJar, extractedJar, StandardCopyOption.ATOMIC_MOVE);
                }
                extractedJars.add(extractedJar);
            }
        }
        return extractedJars;
    }

    protected abstract void loadPlatform();

    @Nullable
    protected abstract ClassLoader getModClassLoader();

    protected void addToClasspath(Path mainJar, List<Path> innerJars) {
        this.addToClasspath(mainJar);
        for (Path jar : innerJars) {
            this.addToClasspath(jar);
        }
    }

    protected abstract void addToClasspath(Path var1);

    protected boolean classpathUpdatesImmediately() {
        return true;
    }

    protected boolean isInClassPath() {
        ClassLoader loader = this.getModClassLoader();
        if (loader == null) {
            return false;
        }
        return loader.getResource(CLASS_NAME.replace('.', '/') + ".class") != null;
    }

    public final void initialize() {
        if (!this.isInClassPath()) {
            return;
        }
        this.doInitialize();
    }

    protected void doInitialize() {
        try {
            ClassLoader loader = this.getModClassLoader();
            if (loader == null) {
                throw new IllegalStateException("Essential is about to be initialized but no associated class loader was found.");
            }
            Class.forName(CLASS_NAME, false, loader).getDeclaredMethod("initialize", File.class).invoke(null, this.gameDir.toFile());
        }
        catch (Throwable e) {
            throw new RuntimeException("Unexpected error", e);
        }
    }

    public static URI asJar(URI uri) throws URISyntaxException {
        return new URI("jar:" + uri.getScheme(), uri.getHost(), uri.getPath(), uri.getFragment());
    }

    private boolean downloadFile(String url, Path target, String expectedHash) throws IOException {
        if (!this.attemptDownload(url, target)) {
            LOGGER.warn("Unable to download Essential, please check your internet connection. If the problem persists, please contact Support.");
            Files.deleteIfExists(target);
            return false;
        }
        String downloadedChecksum = Checksum.getChecksum(target);
        if (downloadedChecksum.equals(expectedHash)) {
            return true;
        }
        LOGGER.warn("Downloaded Essential file checksum did not match what we expected (downloaded={}, expected={}", new Object[]{downloadedChecksum, expectedHash});
        Files.deleteIfExists(target);
        return false;
    }

    /*
     * Exception decompiling
     */
    private boolean attemptDownload(String url, Path target) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void logConnectionInfoOnError(URLConnection connection) {
        if (connection == null) {
            return;
        }
        LOGGER.error("url: {}", new Object[]{connection.getURL()});
        LOGGER.error("cf-ray: {}", new Object[]{connection.getHeaderField("cf-ray")});
    }

    private static class FileMeta {
        String url;
        String checksum;

        public FileMeta(String url, String checksum) {
            this.url = url;
            this.checksum = checksum;
        }
    }
}

