/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import gg.essential.loader.stage2.EssentialLoaderBase;
import gg.essential.loader.stage2.RuntimeModRemapper;
import gg.essential.loader.stage2.jij.JarInJarDependenciesHandler;
import gg.essential.loader.stage2.restart.ForkedNeedsRestartUI;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixins;

public class EssentialLoader
extends EssentialLoaderBase {
    private static final Logger LOGGER = LogManager.getLogger(EssentialLoader.class);
    private final LoaderInternals loaderInternals = new LoaderInternals();
    private final JarInJarDependenciesHandler jijHandler = new JarInJarDependenciesHandler(this.getExtractedJarsRoot());

    public EssentialLoader(Path gameDir, String gameVersion) {
        super(gameDir, gameVersion, true);
    }

    @Override
    protected void loadPlatform() {
    }

    @Override
    protected ClassLoader getModClassLoader() {
        return this.getClass().getClassLoader().getParent().getParent();
    }

    private void addToClassLoader(URL url) {
        try {
            this.loaderInternals.addToClassLoaderViaFabricLauncherBase(url);
            return;
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to add URL to classpath via FabricLauncherBase:", t);
            try {
                this.loaderInternals.addToClassLoaderViaReflection(url);
                return;
            }
            catch (Throwable t2) {
                LOGGER.warn("Failed to add URL to classpath via classloader reflection:", t2);
                throw new RuntimeException("Failed to add Essential jar to parent ClassLoader. See preceding exception(s).");
            }
        }
    }

    private ModMetadata parseMetadata(Path path) throws Exception {
        try (FileSystem fileSystem = FileSystems.newFileSystem(EssentialLoader.asJar(path.toUri()), Collections.emptyMap());){
            Path fabricJson = fileSystem.getPath("fabric.mod.json", new String[0]);
            if (!Files.exists(fabricJson, new LinkOption[0])) {
                ModMetadata modMetadata = null;
                return modMetadata;
            }
            ModMetadata modMetadata = this.loaderInternals.parseModMetadata(path, fabricJson);
            return modMetadata;
        }
    }

    private void addFakeMod(Path path, URL url) throws Exception {
        ModMetadata metadata = this.parseMetadata(path);
        this.loaderInternals.injectFakeMod(path, url, metadata);
    }

    @Override
    protected void addToClasspath(Path mainJar, List<Path> innerJars) {
        innerJars = innerJars.stream().flatMap(path -> this.jijHandler.loadMod((Path)path).stream()).collect(Collectors.toCollection(ArrayList::new));
        if (!this.jijHandler.complete()) {
            ForkedNeedsRestartUI ui = new ForkedNeedsRestartUI(this.jijHandler.getUpdatedModNames(), this.jijHandler.getModsToDisable());
            ui.show();
            ui.waitForClose();
            ui.exit();
            return;
        }
        super.addToClasspath(mainJar, innerJars);
    }

    @Override
    protected void addToClasspath(Path path) {
        URL url;
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            try {
                RuntimeModRemapper runtimeModRemapper = new RuntimeModRemapper(this.loaderInternals);
                path = runtimeModRemapper.remap(path, this.parseMetadata(path));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to remap Essential to dev mappings", e);
            }
        }
        try {
            url = path.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.addToClassLoader(url);
        try {
            this.addFakeMod(path, url);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to add dummy mod container. Essential will be missing from mod menu.", t);
        }
    }

    @Override
    protected void doInitialize() {
        super.doInitialize();
        try {
            this.chainLoadMixins();
        }
        catch (Throwable t) {
            LOGGER.error("Failed to load mixin configs:", t);
        }
    }

    private void chainLoadMixins() throws ReflectiveOperationException {
        if (Mixins.getUnvisitedCount() == 0) {
            return;
        }
        MixinEnvironment environment = MixinEnvironment.getDefaultEnvironment();
        Object transformer = environment.getActiveTransformer();
        Field processorField = transformer.getClass().getDeclaredField("processor");
        processorField.setAccessible(true);
        Object processor = processorField.get(transformer);
        Method select = processor.getClass().getDeclaredMethod("select", MixinEnvironment.class);
        select.setAccessible(true);
        select.invoke(processor, environment);
    }

    public class LoaderInternals {
        private Class<?> findImplClass(String name) throws ClassNotFoundException {
            try {
                return Class.forName("net.fabricmc.loader.impl." + name);
            }
            catch (ClassNotFoundException e) {
                return Class.forName("net.fabricmc.loader." + name);
            }
        }

        private void addToClassLoaderViaFabricLauncherBase(URL url) {
            FabricLauncherBase.getLauncher().propose(url);
        }

        private void addToClassLoaderViaReflection(URL url) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            ClassLoader classLoader = EssentialLoader.this.getModClassLoader();
            if (classLoader == null) {
                throw new IllegalStateException("Failed to traverse class loader hierarchy to find mod class loader.");
            }
            Method method = classLoader.getClass().getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)classLoader, url);
        }

        private ModMetadata parseModMetadata(Path modPath, Path fabricJson) throws Exception {
            Class<?> ModMetadataParser = this.findImplClass("metadata.ModMetadataParser");
            try {
                return (ModMetadata)ModMetadataParser.getDeclaredMethod("parseMetadata", Logger.class, Path.class).invoke(null, LOGGER, fabricJson);
            }
            catch (NoSuchMethodException e) {
                Throwable throwable = null;
                try (InputStream in = Files.newInputStream(fabricJson, new OpenOption[0]);){
                    ModMetadata modMetadata = (ModMetadata)ModMetadataParser.getDeclaredMethod("parseMetadata", InputStream.class, String.class, List.class).invoke(null, in, modPath.toString(), Collections.emptyList());
                    return modMetadata;
                }
                catch (NoSuchMethodException e1) {
                    Class<?> VersionOverrides = this.findImplClass("metadata.VersionOverrides");
                    Class<?> DependencyOverrides = this.findImplClass("metadata.DependencyOverrides");
                    Object versionOverrides = VersionOverrides.getConstructor(new Class[0]).newInstance(new Object[0]);
                    Object dependencyOverrides = DependencyOverrides.getConstructor(Path.class).newInstance(Paths.get("_invalid_", new String[0]));
                    ModMetadata modMetadata = (ModMetadata)ModMetadataParser.getDeclaredMethod("parseMetadata", InputStream.class, String.class, List.class, VersionOverrides, DependencyOverrides).invoke(null, in, modPath.toString(), Collections.emptyList(), versionOverrides, dependencyOverrides);
                    return modMetadata;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remapMod(ModMetadata metadata, Path inputPath, Path outputPath) throws Exception {
            Class<?> ModCandidate = this.findImplClass("discovery.ModCandidate");
            Class<?> ModResolver = this.findImplClass("discovery.ModResolver");
            Class<?> RuntimeModRemapper2 = this.findImplClass("discovery.RuntimeModRemapper");
            Object candidate = this.createCandidate(inputPath, inputPath.toUri().toURL(), metadata);
            try {
                Method getInMemoryFs = ModResolver.getDeclaredMethod("getInMemoryFs", new Class[0]);
                Method remap = RuntimeModRemapper2.getDeclaredMethod("remap", Collection.class, FileSystem.class);
                Method getOriginUrl = ModCandidate.getDeclaredMethod("getOriginUrl", new Class[0]);
                FileSystem fileSystem = (FileSystem)getInMemoryFs.invoke(null, new Object[0]);
                Object result = remap.invoke(null, Collections.singleton(candidate), fileSystem);
                Object remappedCandidate = ((Collection)result).iterator().next();
                URL remappedUrl = (URL)getOriginUrl.invoke(remappedCandidate, new Object[0]);
                try (InputStream in = remappedUrl.openStream();){
                    Files.copy(in, outputPath, new CopyOption[0]);
                }
            }
            catch (NoSuchMethodException e) {
                Method remap = RuntimeModRemapper2.getDeclaredMethod("remap", Collection.class, Path.class, Path.class);
                Path tmpDir = Files.createTempDirectory("remap-tmp", new FileAttribute[0]);
                Path outDir = Files.createTempDirectory("remap-out", new FileAttribute[0]);
                try {
                    Path resultPath;
                    remap.invoke(null, Collections.singleton(candidate), tmpDir, outDir);
                    try {
                        Method getPath = ModCandidate.getDeclaredMethod("getPath", new Class[0]);
                        resultPath = (Path)getPath.invoke(candidate, new Object[0]);
                    }
                    catch (NoSuchMethodException e1) {
                        Method getPaths = ModCandidate.getDeclaredMethod("getPaths", new Class[0]);
                        List paths = (List)getPaths.invoke(candidate, new Object[0]);
                        resultPath = (Path)paths.get(0);
                    }
                    Files.move(resultPath, outputPath, new CopyOption[0]);
                }
                catch (Throwable throwable) {
                    MoreFiles.deleteRecursively((Path)tmpDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
                    MoreFiles.deleteRecursively((Path)outDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
                    throw throwable;
                }
                MoreFiles.deleteRecursively((Path)tmpDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
                MoreFiles.deleteRecursively((Path)outDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            }
        }

        private Object createCandidate(Path path, URL url, Object metadata) throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException, NoSuchMethodException {
            Class<?> LoaderModMetadata = this.findImplClass("metadata.LoaderModMetadata");
            Class<?> ModCandidate = this.findImplClass("discovery.ModCandidate");
            try {
                return ModCandidate.getConstructor(LoaderModMetadata, URL.class, Integer.TYPE, Boolean.TYPE).newInstance(metadata, url, 0, true);
            }
            catch (NoSuchMethodException e) {
                try {
                    Method createCandidate = ModCandidate.getDeclaredMethod("createPlain", Path.class, LoaderModMetadata, Boolean.TYPE, Collection.class);
                    createCandidate.setAccessible(true);
                    return createCandidate.invoke(null, path, metadata, true, Collections.emptyList());
                }
                catch (NoSuchMethodException e1) {
                    Method createCandidate = ModCandidate.getDeclaredMethod("createPlain", List.class, LoaderModMetadata, Boolean.TYPE, Collection.class);
                    createCandidate.setAccessible(true);
                    return createCandidate.invoke(null, Collections.singletonList(path), metadata, true, Collections.emptyList());
                }
            }
        }

        private void injectFakeMod(Path path, URL url, ModMetadata metadata) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException, InstantiationException {
            Object modContainer;
            Class<?> ModContainerImpl;
            FabricLoader fabricLoader = FabricLoader.getInstance();
            Class<?> fabricLoaderClass = fabricLoader.getClass();
            try {
                ModContainerImpl = this.findImplClass("ModContainerImpl");
            }
            catch (ClassNotFoundException e) {
                ModContainerImpl = this.findImplClass("ModContainer");
            }
            Class<?> LoaderModMetadata = this.findImplClass("metadata.LoaderModMetadata");
            Class<?> EntrypointMetadata = this.findImplClass("metadata.EntrypointMetadata");
            Field modMapField = fabricLoaderClass.getDeclaredField("modMap");
            Field modsField = fabricLoaderClass.getDeclaredField("mods");
            Field entrypointStorageField = fabricLoaderClass.getDeclaredField("entrypointStorage");
            Field adapterMapField = fabricLoaderClass.getDeclaredField("adapterMap");
            modMapField.setAccessible(true);
            modsField.setAccessible(true);
            entrypointStorageField.setAccessible(true);
            adapterMapField.setAccessible(true);
            List mods = (List)modsField.get(fabricLoader);
            Map modMap = (Map)modMapField.get(fabricLoader);
            Object entrypointStorage = entrypointStorageField.get(fabricLoader);
            Map adapterMap = (Map)adapterMapField.get(fabricLoader);
            Method getMixinConfigs = LoaderModMetadata.getDeclaredMethod("getMixinConfigs", EnvType.class);
            for (String mixinConfig : (Collection)getMixinConfigs.invoke((Object)metadata, EnvType.CLIENT)) {
                Mixins.addConfiguration((String)mixinConfig);
            }
            try {
                modContainer = ModContainerImpl.getConstructor(LoaderModMetadata, URL.class).newInstance(metadata, url);
            }
            catch (NoSuchMethodException e) {
                try {
                    modContainer = ModContainerImpl.getConstructor(LoaderModMetadata, Path.class).newInstance(metadata, path);
                }
                catch (NoSuchMethodException e1) {
                    modContainer = ModContainerImpl.getConstructor(this.findImplClass("discovery.ModCandidate")).newInstance(this.createCandidate(path, url, metadata));
                }
            }
            mods.add(modContainer);
            modMap.put(metadata.getId(), modContainer);
            Method addMethod = entrypointStorage.getClass().getDeclaredMethod("add", ModContainerImpl, String.class, EntrypointMetadata, Map.class);
            addMethod.setAccessible(true);
            Method getEntrypointKeys = LoaderModMetadata.getDeclaredMethod("getEntrypointKeys", new Class[0]);
            Method getEntrypoints = LoaderModMetadata.getDeclaredMethod("getEntrypoints", String.class);
            for (String key : (Collection)getEntrypointKeys.invoke((Object)metadata, new Object[0])) {
                for (Object entrypointMetadata : (List)getEntrypoints.invoke((Object)metadata, key)) {
                    addMethod.invoke(entrypointStorage, modContainer, key, entrypointMetadata, adapterMap);
                }
            }
        }
    }
}

