/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.transfer.v1.fluid;

import java.util.Collection;
import java.util.Iterator;
import net.fabricmc.fabric.api.lookup.v1.custom.ApiProviderMap;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.impl.transfer.fluid.CauldronStorage;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5556;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class CauldronFluidContent {
    public final class_2248 block;
    public final class_3611 fluid;
    public final long amountPerLevel;
    public final int maxLevel;
    @Nullable
    public final class_2758 levelProperty;
    private static final ApiProviderMap<class_2248, CauldronFluidContent> BLOCK_TO_CAULDRON = ApiProviderMap.create();
    private static final ApiProviderMap<class_3611, CauldronFluidContent> FLUID_TO_CAULDRON = ApiProviderMap.create();

    private CauldronFluidContent(class_2248 block, class_3611 fluid, long amountPerLevel, int maxLevel, @Nullable class_2758 levelProperty) {
        this.block = block;
        this.fluid = fluid;
        this.amountPerLevel = amountPerLevel;
        this.maxLevel = maxLevel;
        this.levelProperty = levelProperty;
    }

    @Nullable
    public static CauldronFluidContent getForBlock(class_2248 block) {
        return (CauldronFluidContent)BLOCK_TO_CAULDRON.get((Object)block);
    }

    @Nullable
    public static CauldronFluidContent getForFluid(class_3611 fluid) {
        return (CauldronFluidContent)FLUID_TO_CAULDRON.get((Object)fluid);
    }

    public static synchronized CauldronFluidContent registerCauldron(class_2248 block, class_3611 fluid, long amountPerLevel, @Nullable class_2758 levelProperty) {
        CauldronFluidContent data;
        CauldronFluidContent existingBlockData = (CauldronFluidContent)BLOCK_TO_CAULDRON.get((Object)block);
        if (existingBlockData != null) {
            return existingBlockData;
        }
        if (FLUID_TO_CAULDRON.get((Object)fluid) != null) {
            throw new IllegalArgumentException("Fluid already has a mapping for a different block.");
        }
        if (levelProperty == null) {
            data = new CauldronFluidContent(block, fluid, amountPerLevel, 1, null);
        } else {
            Collection levels = levelProperty.method_11898();
            if (levels.size() == 0) {
                throw new RuntimeException("Cauldron should have at least one possible level.");
            }
            int minLevel = Integer.MAX_VALUE;
            int maxLevel = 0;
            Iterator iterator = levels.iterator();
            while (iterator.hasNext()) {
                int level = (Integer)iterator.next();
                minLevel = Math.min(minLevel, level);
                maxLevel = Math.max(maxLevel, level);
            }
            if (minLevel != 1 || maxLevel < 1) {
                throw new IllegalStateException("Minimum level should be 1, and maximum level should be >= 1.");
            }
            data = new CauldronFluidContent(block, fluid, amountPerLevel, maxLevel, levelProperty);
        }
        BLOCK_TO_CAULDRON.putIfAbsent((Object)block, (Object)data);
        FLUID_TO_CAULDRON.putIfAbsent((Object)fluid, (Object)data);
        FluidStorage.SIDED.registerForBlocks((world, pos, state, be, context) -> CauldronStorage.get(world, pos), new class_2248[]{block});
        return data;
    }

    public int currentLevel(class_2680 state) {
        if (this.fluid == class_3612.field_15906) {
            return 0;
        }
        if (this.levelProperty == null) {
            return 1;
        }
        return (Integer)state.method_11654((class_2769)this.levelProperty);
    }

    static {
        CauldronFluidContent.registerCauldron(class_2246.field_10593, class_3612.field_15906, 81000L, null);
        CauldronFluidContent.registerCauldron(class_2246.field_27097, (class_3611)class_3612.field_15910, 27000L, class_5556.field_27206);
        CauldronFluidContent.registerCauldron(class_2246.field_27098, (class_3611)class_3612.field_15908, 81000L, null);
    }
}

