/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry.type.collapsed;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class CollapsibleEntryRegistryImpl
implements CollapsibleEntryRegistry {
    private final List<Entry> entries = new ArrayList<Entry>();

    @Override
    public <T> void group(class_2960 id, class_2561 name, List<? extends EntryStack<? extends T>> stacks) {
        Objects.requireNonNull(stacks, "stacks");
        this.entries.add(new Entry(id.method_12836(), name, new ListMatcher(stacks)));
    }

    @Override
    public void group(class_2960 id, class_2561 name, Predicate<? extends EntryStack<?>> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        this.entries.add(new Entry(id.method_12836(), name, (stack, hashExact) -> predicate.test(stack)));
    }

    @Override
    public void startReload() {
        this.entries.clear();
    }

    @Override
    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerCollapsibleEntries(this);
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public static class Entry {
        private final String modId;
        private final class_2561 name;
        private final Matcher matcher;
        private boolean expanded;

        public Entry(String modId, class_2561 name, Matcher matcher) {
            this.modId = modId;
            this.name = name;
            this.matcher = matcher;
        }

        public String getModId() {
            return this.modId;
        }

        public class_2561 getName() {
            return this.name;
        }

        public Matcher getMatcher() {
            return this.matcher;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public void setExpanded(boolean expanded) {
            this.expanded = expanded;
        }
    }

    private static class ListMatcher
    implements Matcher {
        private final Long2ObjectMap<EntryStack<?>> stacks;

        public ListMatcher(List<? extends EntryStack<?>> stacks) {
            this.stacks = new Long2ObjectOpenHashMap(stacks.size() + 1);
            for (EntryStack<?> stack : stacks) {
                this.stacks.put(EntryStacks.hashExact(stack), stack);
            }
        }

        @Override
        public boolean matches(EntryStack<?> stack, long hashExact) {
            EntryStack entryStack = (EntryStack)this.stacks.get(hashExact);
            if (entryStack == null) {
                return false;
            }
            return EntryStacks.equalsExact(entryStack, stack);
        }
    }

    @FunctionalInterface
    public static interface Matcher {
        public boolean matches(EntryStack<?> var1, long var2);
    }
}

