/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.entrylist;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.gui.widget.BatchedEntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.CachedEntryListRender;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.CachingEntryRenderer;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.CollapsingEntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListStackEntry;
import me.shedaniel.rei.impl.common.entry.type.collapsed.CollapsedStack;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class PaginatedEntryListWidget
extends CollapsingEntryListWidget {
    private List<Object> stacks = new ArrayList<Object>();
    protected List<EntryListStackEntry> entries = Collections.emptyList();
    private int page;

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public void setPage(int page) {
        this.page = page;
    }

    @Override
    protected void renderEntries(boolean fastEntryRendering, class_4587 matrices, int mouseX, int mouseY, float delta) {
        BatchedEntryRendererManager manager;
        if (ConfigObject.getInstance().doesCacheEntryRendering()) {
            for (EntryListStackEntry entry : this.entries) {
                CachedEntryListRender.Sprite sprite;
                CollapsedStack collapsedStack = entry.getCollapsedStack();
                if (collapsedStack != null && !collapsedStack.isExpanded() || entry.our != null || (sprite = CachedEntryListRender.get(entry.getCurrentEntry())) == null) continue;
                CachingEntryRenderer renderer = new CachingEntryRenderer(sprite, () -> ((PaginatedEntryListWidget)this).method_25305());
                entry.our = ClientEntryStacks.setRenderer(entry.getCurrentEntry().copy().cast(), stack -> renderer);
            }
        }
        if ((manager = new BatchedEntryRendererManager()).isFastEntryRendering()) {
            for (EntryListStackEntry entry : this.entries) {
                CollapsedStack collapsedStack = entry.getCollapsedStack();
                if (collapsedStack != null && !collapsedStack.isExpanded()) {
                    manager.addSlow(entry);
                    continue;
                }
                manager.add(entry);
            }
        } else {
            manager.addAllSlow(this.entries);
        }
        manager.render(this.debugger.debugTime, this.debugger.size, this.debugger.time, matrices, mouseX, mouseY, delta);
    }

    @Override
    public int getTotalPages() {
        return class_3532.method_15386((float)((float)this.stacks.size() / (float)this.entries.size()));
    }

    @Override
    protected void updateEntries(int entrySize, boolean zoomed) {
        this.page = Math.max(this.page, 0);
        ArrayList entries = Lists.newArrayList();
        int width = this.innerBounds.width / entrySize;
        int height = this.innerBounds.height / entrySize;
        for (int currentY = 0; currentY < height; ++currentY) {
            for (int currentX = 0; currentX < width; ++currentX) {
                int slotX = currentX * entrySize + this.innerBounds.x;
                int slotY = currentY * entrySize + this.innerBounds.y;
                if (!PaginatedEntryListWidget.notSteppingOnExclusionZones(slotX - 1, slotY - 1, entrySize, entrySize)) continue;
                entries.add((EntryListStackEntry)new EntryListStackEntry(this, slotX, slotY, entrySize, zoomed).noBackground());
            }
        }
        this.page = Math.max(Math.min(this.page, this.getTotalPages() - 1), 0);
        int skip = Math.max(0, this.page * entries.size());
        List subList = this.stacks.stream().skip(skip).limit(Math.max(0, entries.size() - Math.max(0, -this.page * entries.size()))).toList();
        Int2ObjectMap<CollapsedStack> indexedCollapsedStack = this.getCollapsedStackIndexed();
        for (int i = 0; i < subList.size(); ++i) {
            Object stack = subList.get(i);
            EntryListStackEntry entry = (EntryListStackEntry)entries.get(i + Math.max(0, -this.page * entries.size()));
            entry.clearStacks();
            if (stack instanceof EntryStack) {
                EntryStack entryStack = (EntryStack)stack;
                entry.entry(entryStack);
            } else {
                entry.entries((Collection)((List)stack));
            }
            entry.collapsed((CollapsedStack)indexedCollapsedStack.get(i + skip));
        }
        this.entries = entries;
    }

    @Override
    public List<Object> getStacks() {
        return this.stacks;
    }

    @Override
    public void setStacks(List<Object> stacks) {
        this.stacks = stacks;
    }

    @Override
    public Stream<EntryStack<?>> getEntries() {
        return this.entries.stream().map(EntryWidget::getCurrentEntry);
    }

    @Override
    protected List<EntryListStackEntry> getEntryWidgets() {
        return this.entries;
    }
}

