/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.entrylist;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.EntryPanelOrdering;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.search.AsyncSearchManager;
import me.shedaniel.rei.impl.common.entry.type.collapsed.CollapsedStack;
import me.shedaniel.rei.impl.common.entry.type.collapsed.CollapsibleEntryRegistryImpl;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class EntryListSearchManager {
    private static final Comparator<? super EntryStack<?>> ENTRY_NAME_COMPARER = Comparator.comparing(stack -> stack.asFormatStrippedText().getString());
    private static final Comparator<? super EntryStack<?>> ENTRY_GROUP_COMPARER = Comparator.comparingInt(stack -> {
        class_1761 group;
        if (stack.getType() == VanillaEntryTypes.ITEM && (group = ((class_1799)stack.getValue()).method_7909().method_7859()) != null) {
            return group.method_7741();
        }
        return Integer.MAX_VALUE;
    });
    public static final EntryListSearchManager INSTANCE = new EntryListSearchManager();
    private AsyncSearchManager searchManager = AsyncSearchManager.createDefault();

    public void update(String searchTerm, boolean ignoreLastSearch, Consumer<List<Object>> update) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (ignoreLastSearch) {
            this.searchManager.markDirty();
        }
        this.searchManager.updateFilter(searchTerm);
        if (this.searchManager.isDirty()) {
            this.searchManager.getAsync(list -> {
                List<Object> finalList = this.collapse(this.copyAndOrder((List<EntryStack<?>>)list));
                if (ConfigObject.getInstance().doDebugSearchTimeRequired()) {
                    RoughlyEnoughItemsCore.LOGGER.info("Search Used: %s", stopwatch.stop().toString());
                }
                class_310.method_1551().method_19537(() -> update.accept(finalList));
            });
        }
    }

    private List<EntryStack<?>> copyAndOrder(List<EntryStack<?>> list) {
        list = new ArrayList(list);
        EntryPanelOrdering ordering = ConfigObject.getInstance().getItemListOrdering();
        if (ordering == EntryPanelOrdering.NAME) {
            list.sort(ENTRY_NAME_COMPARER);
        }
        if (ordering == EntryPanelOrdering.GROUPS) {
            list.sort(ENTRY_GROUP_COMPARER);
        }
        if (!ConfigObject.getInstance().isItemListAscending()) {
            Collections.reverse(list);
        }
        return list;
    }

    private List<Object> collapse(List<EntryStack<?>> stacks) {
        CollapsibleEntryRegistryImpl collapsibleRegistry = (CollapsibleEntryRegistryImpl)CollapsibleEntryRegistry.getInstance();
        HashMap<CollapsibleEntryRegistryImpl.Entry, @Nullable V> entries = new HashMap();
        for (CollapsibleEntryRegistryImpl.Entry entry : collapsibleRegistry.getEntries()) {
            entries.put(entry, null);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (EntryStack<?> stack : stacks) {
            long hashExact = EntryStacks.hashExact(stack);
            boolean matchedAny = false;
            for (Map.Entry entry : entries.entrySet()) {
                CollapsibleEntryRegistryImpl.Entry entry2 = (CollapsibleEntryRegistryImpl.Entry)entry.getKey();
                if (!entry2.getMatcher().matches(stack, hashExact)) continue;
                CollapsedStack collapsed = (CollapsedStack)entry.getValue();
                if (collapsed == null) {
                    ArrayList ingredient = new ArrayList();
                    ingredient.add(stack);
                    collapsed = new CollapsedStack(ingredient, entry2);
                    entry.setValue(collapsed);
                    list.add(collapsed);
                } else {
                    collapsed.getIngredient().add(stack);
                }
                matchedAny = true;
            }
            if (matchedAny) continue;
            list.add(stack);
        }
        return list;
    }

    public boolean matches(EntryStack<?> stack) {
        return this.searchManager.matches(stack);
    }
}

