/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.biome;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.impl.biome.BiomeSourceAccess;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_4766;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@ApiStatus.Internal
public final class NetherBiomeData {
    private static final Set<class_5321<class_1959>> NETHER_BIOMES = new HashSet<class_5321<class_1959>>();
    private static final Map<class_5321<class_1959>, class_6544.class_4762> NETHER_BIOME_NOISE_POINTS = new HashMap<class_5321<class_1959>, class_6544.class_4762>();
    private static final Logger LOGGER = LogUtils.getLogger();

    private NetherBiomeData() {
    }

    public static void addNetherBiome(class_5321<class_1959> biome, class_6544.class_4762 spawnNoisePoint) {
        Preconditions.checkArgument((biome != null ? 1 : 0) != 0, (Object)"Biome is null");
        Preconditions.checkArgument((spawnNoisePoint != null ? 1 : 0) != 0, (Object)"MultiNoiseUtil.NoiseValuePoint is null");
        NETHER_BIOME_NOISE_POINTS.put(biome, spawnNoisePoint);
        NetherBiomeData.clearBiomeSourceCache();
    }

    public static Map<class_5321<class_1959>, class_6544.class_4762> getNetherBiomeNoisePoints() {
        return NETHER_BIOME_NOISE_POINTS;
    }

    public static boolean canGenerateInNether(class_5321<class_1959> biome) {
        if (NETHER_BIOMES.isEmpty()) {
            class_4766 source = class_4766.class_5305.field_24723.method_28469(class_5458.field_25933);
            for (class_6880 entry : source.method_28443()) {
                class_5458.field_25933.method_29113((Object)((class_1959)entry.comp_349())).ifPresent(NETHER_BIOMES::add);
            }
        }
        return NETHER_BIOMES.contains(biome) || NETHER_BIOME_NOISE_POINTS.containsKey(biome);
    }

    private static void clearBiomeSourceCache() {
        NETHER_BIOMES.clear();
    }

    private static class_6544.class_6547<class_6880<class_1959>> withModdedBiomeEntries(class_6544.class_6547<class_6880<class_1959>> entries, class_2378<class_1959> biomeRegistry) {
        if (NETHER_BIOME_NOISE_POINTS.isEmpty()) {
            return entries;
        }
        ArrayList<Pair> entryList = new ArrayList<Pair>(entries.method_38128());
        for (Map.Entry<class_5321<class_1959>, class_6544.class_4762> entry : NETHER_BIOME_NOISE_POINTS.entrySet()) {
            if (biomeRegistry.method_35842(entry.getKey())) {
                entryList.add(Pair.of((Object)entry.getValue(), (Object)biomeRegistry.method_40290(entry.getKey())));
                continue;
            }
            LOGGER.warn("Nether biome {} not loaded", (Object)entry.getKey().method_29177());
        }
        return new class_6544.class_6547(entryList);
    }

    public static void modifyBiomeSource(class_2378<class_1959> biomeRegistry, class_1966 biomeSource) {
        class_4766 multiNoiseBiomeSource;
        if (biomeSource instanceof class_4766 && ((BiomeSourceAccess)(multiNoiseBiomeSource = (class_4766)biomeSource)).fabric_shouldModifyBiomeEntries() && multiNoiseBiomeSource.method_38168(class_4766.class_5305.field_24723)) {
            multiNoiseBiomeSource.field_34498 = NetherBiomeData.withModdedBiomeEntries((class_6544.class_6547<class_6880<class_1959>>)((class_6544.class_6547)class_4766.class_5305.field_24723.field_24726.apply(biomeRegistry)), biomeRegistry);
            multiNoiseBiomeSource.field_20643 = multiNoiseBiomeSource.field_34498.method_38128().stream().map(Pair::getSecond).collect(Collectors.toSet());
            ((BiomeSourceAccess)multiNoiseBiomeSource).fabric_setModifyBiomeEntries(false);
        }
    }
}

